/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.stitch.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.duracloud.common.model.ContentItem;
import org.duracloud.domain.Content;
import org.duracloud.stitch.datasource.DataSource;

public class MultiContentInputStream
extends InputStream {
    private DataSource dataSource;
    private Iterator<ContentItem> contents;
    private InputStream currentStream;

    public MultiContentInputStream(DataSource dataSource, List<ContentItem> contentItems) {
        this.dataSource = dataSource;
        this.contents = contentItems.iterator();
        this.currentStream = null;
    }

    @Override
    public int read() throws IOException {
        int bite;
        if (null == this.currentStream) {
            if (this.contents.hasNext()) {
                this.currentStream = this.nextStream();
            } else {
                return -1;
            }
        }
        if (-1 == (bite = this.currentStream.read()) && this.contents.hasNext()) {
            this.currentStream = this.nextStream();
            bite = this.currentStream.read();
        }
        return bite;
    }

    private InputStream nextStream() {
        return this.getStream(this.contents.next());
    }

    private InputStream getStream(ContentItem contentItem) {
        Content content = this.dataSource.getContent(contentItem.getSpaceId(), contentItem.getContentId());
        return content.getStream();
    }
}

