/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.backup;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.duracloud.sync.backup.ChangedListBackupManager;
import org.duracloud.sync.config.SyncToolConfig;
import org.duracloud.sync.mgmt.ChangedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncBackupManager {
    private final Logger logger = LoggerFactory.getLogger(SyncBackupManager.class);
    private ChangedListBackupManager backupManager;
    private ExecutorService execPool;

    public SyncBackupManager(File backupDir, long frequency, SyncToolConfig syncConfig) {
        this.logger.info("Starting Sync Backup Manager");
        this.backupManager = new ChangedListBackupManager(ChangedList.getInstance(), backupDir, frequency, syncConfig);
        this.execPool = Executors.newFixedThreadPool(1);
    }

    public long attemptRestart() {
        return this.backupManager.loadBackup();
    }

    public boolean hasBackups() {
        return this.backupManager.hasBackups();
    }

    public void startupBackups() {
        this.execPool.execute(this.backupManager);
    }

    public void endBackups() {
        this.logger.info("Closing Sync Backup Manager, ending backups");
        this.backupManager.endBackup();
        this.execPool.shutdown();
    }
}

