/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.duracloud.client.ContentStore;
import org.duracloud.client.util.StoreClientUtil;
import org.duracloud.common.util.ApplicationConfig;
import org.duracloud.sync.backup.SyncBackupManager;
import org.duracloud.sync.config.SyncToolConfig;
import org.duracloud.sync.config.SyncToolConfigParser;
import org.duracloud.sync.endpoint.DuraStoreChunkSyncEndpoint;
import org.duracloud.sync.endpoint.EndPointLogger;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.StatusManager;
import org.duracloud.sync.mgmt.SyncManager;
import org.duracloud.sync.monitor.DirectoryUpdateMonitor;
import org.duracloud.sync.walker.DeleteChecker;
import org.duracloud.sync.walker.DirWalker;
import org.duracloud.sync.walker.RestartDirWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncTool {
    private static final String SYNCTOOL_PROPERTIES = "synctool.properties";
    private final Logger logger = LoggerFactory.getLogger(SyncTool.class);
    private SyncToolConfig syncConfig;
    private SyncManager syncManager;
    private SyncBackupManager syncBackupManager;
    private DirectoryUpdateMonitor dirMonitor;
    private SyncEndpoint syncEndpoint;
    private DirWalker dirWalker;
    private DeleteChecker deleteChecker;
    private String version;

    public SyncTool() {
        Properties props = ApplicationConfig.getPropsFromResource((String)SYNCTOOL_PROPERTIES);
        this.version = props.getProperty("version");
    }

    protected void setSyncConfig(SyncToolConfig syncConfig) {
        this.syncConfig = syncConfig;
        this.syncConfig.setVersion(this.version);
    }

    protected boolean restartPossible() {
        SyncToolConfigParser syncConfigParser;
        SyncToolConfig prevConfig;
        boolean restart = false;
        if (!this.syncConfig.isCleanStart() && (prevConfig = (syncConfigParser = new SyncToolConfigParser()).retrievePrevConfig(this.syncConfig.getWorkDir())) != null) {
            restart = this.configEquals(this.syncConfig, prevConfig);
        }
        return restart;
    }

    protected boolean configEquals(SyncToolConfig currConfig, SyncToolConfig prevConfig) {
        boolean sameHost = currConfig.getHost().equals(prevConfig.getHost());
        boolean sameSpaceId = currConfig.getSpaceId().equals(prevConfig.getSpaceId());
        boolean sameStoreId = this.sameConfig(currConfig.getStoreId(), prevConfig.getStoreId());
        boolean sameSyncDeletes = currConfig.syncDeletes() == prevConfig.syncDeletes();
        boolean sameContentDirs = currConfig.getContentDirs().equals(prevConfig.getContentDirs());
        boolean sameSyncUpdates = currConfig.isSyncUpdates() == prevConfig.isSyncUpdates();
        boolean sameRenameUpdates = currConfig.isRenameUpdates() == prevConfig.isRenameUpdates();
        boolean sameExclude = this.sameConfig(currConfig.getExcludeList(), prevConfig.getExcludeList());
        boolean samePrefix = this.sameConfig(currConfig.getPrefix(), prevConfig.getPrefix());
        return sameHost && sameSpaceId && sameStoreId && sameSyncDeletes && sameContentDirs && sameSyncUpdates && sameRenameUpdates && sameExclude && samePrefix;
    }

    private boolean sameConfig(Object nowConfig, Object prevConfig) {
        return null == nowConfig && null == prevConfig || null != nowConfig && nowConfig.equals(prevConfig);
    }

    private void startSyncManager() {
        StoreClientUtil clientUtil = new StoreClientUtil();
        ContentStore contentStore = clientUtil.createContentStore(this.syncConfig.getHost(), this.syncConfig.getPort(), this.syncConfig.getContext(), this.syncConfig.getUsername(), this.syncConfig.getPassword(), this.syncConfig.getStoreId());
        this.syncEndpoint = new DuraStoreChunkSyncEndpoint(contentStore, this.syncConfig.getUsername(), this.syncConfig.getSpaceId(), this.syncConfig.syncDeletes(), this.syncConfig.getMaxFileSize(), this.syncConfig.isSyncUpdates(), this.syncConfig.isRenameUpdates(), this.syncConfig.isJumpStart(), this.syncConfig.getUpdateSuffix(), this.syncConfig.getPrefix());
        this.syncEndpoint.addEndPointListener(new EndPointLogger());
        this.syncManager = new SyncManager(this.syncConfig.getContentDirs(), this.syncEndpoint, this.syncConfig.getNumThreads(), this.syncConfig.getPollFrequency());
        this.syncManager.beginSync();
    }

    private void startDirWalker() {
        this.dirWalker = DirWalker.start(this.syncConfig.getContentDirs(), this.syncConfig.getExcludeList());
    }

    private void startRestartDirWalker(long lastBackup) {
        this.dirWalker = RestartDirWalker.start(this.syncConfig.getContentDirs(), this.syncConfig.getExcludeList(), lastBackup);
    }

    private void startDeleteChecker() {
        this.deleteChecker = DeleteChecker.start(this.syncEndpoint, this.syncConfig.getSpaceId(), this.syncConfig.getContentDirs(), this.syncConfig.getPrefix());
    }

    private void startDirMonitor() {
        this.dirMonitor = new DirectoryUpdateMonitor(this.syncConfig.getContentDirs(), this.syncConfig.getPollFrequency(), this.syncConfig.syncDeletes());
        this.dirMonitor.startMonitor();
    }

    private void listenForExit() {
        StatusManager statusManager = StatusManager.getInstance();
        statusManager.setVersion(this.version);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        boolean exit = false;
        while (!exit) {
            try {
                String input = br.readLine();
                if (input.equalsIgnoreCase("exit") || input.equalsIgnoreCase("x")) {
                    exit = true;
                    continue;
                }
                if (input.equalsIgnoreCase("config") || input.equalsIgnoreCase("c")) {
                    System.out.println(this.syncConfig.getPrintableConfig());
                    continue;
                }
                if (input.equalsIgnoreCase("status") || input.equalsIgnoreCase("s")) {
                    System.out.println(statusManager.getPrintableStatus());
                    continue;
                }
                System.out.println(this.getPrintableHelp());
            }
            catch (IOException e) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        this.closeSyncTool();
    }

    private void waitForExit() {
        StatusManager statusManager = StatusManager.getInstance();
        statusManager.setVersion(this.version);
        boolean syncDeletes = this.syncConfig.syncDeletes();
        int loops = 0;
        boolean exit = false;
        while (!exit) {
            if (this.dirWalker.walkComplete() && (!syncDeletes || syncDeletes && this.deleteChecker.checkComplete()) && ChangedList.getInstance().getListSize() <= 0 && statusManager.getInWork() <= 0L) {
                exit = true;
                System.out.println("Sync Tool processing complete, final status:");
                System.out.println(statusManager.getPrintableStatus());
                break;
            }
            if (loops >= 60) {
                System.out.println(statusManager.getPrintableStatus());
                loops = 0;
            } else {
                ++loops;
            }
            this.sleep(10000L);
        }
        this.closeSyncTool();
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void closeSyncTool() {
        this.syncBackupManager.endBackups();
        this.syncManager.endSync();
        this.dirMonitor.stopMonitor();
        long inWork = StatusManager.getInstance().getInWork();
        if (inWork > 0L) {
            System.out.println("\nThe Sync Tool will exit after the remaining " + inWork + " work items have completed\n");
        }
    }

    public void runSyncTool() {
        this.logger.info("Starting Sync Tool version " + this.version);
        this.logger.info("Running Sync Tool with configuration: " + this.syncConfig.getPrintableConfig());
        System.out.print("\nStarting up the Sync Tool ...");
        this.startSyncManager();
        System.out.print("...");
        boolean restart = this.restartPossible();
        System.out.print("...");
        File backupDir = new File(this.syncConfig.getWorkDir(), "backup");
        backupDir.mkdirs();
        this.syncBackupManager = new SyncBackupManager(backupDir, this.syncConfig.getPollFrequency(), this.syncConfig.getContentDirs());
        boolean hasABackupFile = this.syncBackupManager.hasBackups();
        if (restart && hasABackupFile) {
            long lastBackup = this.syncBackupManager.attemptRestart();
            System.out.print("...");
            if (lastBackup > 0L) {
                this.logger.info("Running Sync Tool re-start file check");
                this.startRestartDirWalker(lastBackup);
                System.out.print("...");
            }
        }
        if (this.dirWalker == null) {
            this.logger.info("Running Sync Tool complete file check");
            this.startDirWalker();
        }
        this.startBackupsOnDirWalkerCompletion();
        if (this.syncConfig.syncDeletes()) {
            this.startDeleteChecker();
        }
        System.out.print("...");
        this.startDirMonitor();
        System.out.println("... Startup Complete");
        if (this.syncConfig.exitOnCompletion()) {
            System.out.println(this.syncConfig.getPrintableConfig());
            System.out.println("The Sync Tool will exit when processing is complete. Status will be printed every 10 minutes.\n");
            this.waitForExit();
        } else {
            this.printWelcome();
            this.listenForExit();
        }
    }

    private void startBackupsOnDirWalkerCompletion() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (!SyncTool.this.dirWalker.walkComplete()) {
                    SyncTool.this.sleep(100L);
                }
                SyncTool.this.logger.info("Walk complete: starting back up manager...");
                SyncTool.this.syncBackupManager.startupBackups();
            }
        }, "walk-completion-checker thread").start();
    }

    private void printWelcome() {
        System.out.println(this.syncConfig.getPrintableConfig());
        System.out.println(this.getPrintableHelp());
    }

    public String getPrintableHelp() {
        StringBuilder help = new StringBuilder();
        help.append("\n-------------------------------------------\n");
        help.append(" Sync Tool " + this.version + " - Help");
        help.append("\n-------------------------------------------\n");
        help.append("The following commands are available:\n");
        help.append("x - Exits the Sync Tool\n");
        help.append("c - Prints the Sync Tool configuration\n");
        help.append("s - Prints the Sync Tool status\n");
        help.append("-------------------------------------------\n");
        return help.toString();
    }
}

