/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.util.Iterator;
import java.util.Map;
import org.duracloud.chunk.FileChunker;
import org.duracloud.chunk.FileChunkerOptions;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.chunk.writer.DuracloudContentWriter;
import org.duracloud.client.ContentStore;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.stitch.FileStitcher;
import org.duracloud.stitch.datasource.impl.DuraStoreDataSource;
import org.duracloud.stitch.impl.FileStitcherImpl;
import org.duracloud.sync.endpoint.ChunkFilteredIterator;
import org.duracloud.sync.endpoint.DuraStoreSyncEndpoint;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreChunkSyncEndpoint
extends DuraStoreSyncEndpoint {
    private final Logger log = LoggerFactory.getLogger(DuraStoreChunkSyncEndpoint.class);
    private FileChunker chunker;
    private FileStitcher stitcher;

    public DuraStoreChunkSyncEndpoint(ContentStore contentStore, String username, String spaceId, boolean syncDeletes, boolean jumpStart, long maxFileSize) {
        this(contentStore, username, spaceId, syncDeletes, maxFileSize, true, false, jumpStart, ".orig", null);
    }

    public DuraStoreChunkSyncEndpoint(ContentStore contentStore, String username, String spaceId, boolean syncDeletes, long maxFileSize, boolean syncUpdates, boolean renameUpdates, boolean jumpStart, String updateSuffix, String prefix) {
        super(contentStore, username, spaceId, syncDeletes, syncUpdates, renameUpdates, jumpStart, updateSuffix, prefix);
        if (maxFileSize % 1000L != 0L) {
            throw new RuntimeException("Max file size must be factor of 1000");
        }
        DuracloudContentWriter contentWriter = new DuracloudContentWriter(contentStore, username, true);
        FileChunkerOptions chunkerOptions = new FileChunkerOptions(maxFileSize);
        this.chunker = new FileChunker(contentWriter, chunkerOptions);
        this.stitcher = new FileStitcherImpl(new DuraStoreDataSource(contentStore));
    }

    @Override
    protected Map<String, String> getContentProperties(String spaceId, String contentId) {
        Map<String, String> props = super.getContentProperties(spaceId, contentId);
        if (null == props) {
            props = this.getPropertiesIfChunked(spaceId, contentId);
        }
        return props;
    }

    private Map<String, String> getPropertiesIfChunked(String spaceId, String contentId) {
        Map<String, String> props = null;
        String manifestId = contentId + ".dura-manifest";
        try {
            Content manifest = this.stitcher.getContentFromManifest(spaceId, manifestId);
            props = manifest.getProperties();
            this.log.info("Manifest found for content: {}/{}", (Object)spaceId, (Object)contentId);
        }
        catch (Exception e) {
            this.log.debug("Not a chunked content item: {}/{}", (Object)spaceId, (Object)contentId);
        }
        return props;
    }

    @Override
    public void deleteContent(String spaceId, String contentId) throws ContentStoreException {
        boolean contentDeleted = true;
        try {
            super.deleteContent(spaceId, contentId);
        }
        catch (ContentStoreException e) {
            contentDeleted = false;
        }
        if (!contentDeleted) {
            this.log.debug("Maybe content was chunked? {}/{}", (Object)spaceId, (Object)contentId);
            ChunksManifest manifest = this.getManifest(spaceId, contentId);
            if (null != manifest) {
                String manifestId = manifest.getManifestId();
                this.log.info("Deleting all chunks in manifest, {}", (Object)manifestId);
                for (ChunksManifestBean.ManifestEntry entry : manifest.getEntries()) {
                    super.deleteContent(spaceId, entry.getChunkId());
                }
                this.log.info("Deleting manifest: {}/{}", (Object)spaceId, (Object)manifestId);
                super.deleteContent(spaceId, manifestId);
            }
        }
    }

    private ChunksManifest getManifest(String spaceId, String contentId) {
        String manifestId = contentId + ".dura-manifest";
        ChunksManifest manifest = null;
        try {
            manifest = this.stitcher.getManifest(spaceId, manifestId);
        }
        catch (Exception e) {
            this.log.info("No manifest for item: {}/{}", (Object)spaceId, (Object)contentId);
        }
        return manifest;
    }

    @Override
    protected void addUpdateContent(String contentId, MonitoredFile syncFile) {
        Map<String, String> properties = this.createProps(syncFile.getAbsolutePath(), this.getUsername());
        this.chunker.addContent(this.getSpaceId(), contentId, syncFile.getChecksum(), syncFile.length(), syncFile.getStream(), properties);
    }

    @Override
    public Iterator<String> getFilesList() {
        return new ChunkFilteredIterator(super.getFilesList());
    }
}

