/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.Profile;
import com.amazonaws.auth.profile.internal.securitytoken.ProfileCredentialsService;
import com.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import com.amazonaws.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesConfigFileLoader {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFileLoader.class);

    public static Map<String, Profile> loadProfiles(File file, ProfileCredentialsService profileCredentialsService) {
        if (file == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file is null.");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException("AWS credential profiles file not found in the given path: " + file.getAbsolutePath());
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Map<String, Profile> map = ProfilesConfigFileLoader.loadProfiles(fis, profileCredentialsService);
            return map;
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to load AWS credential profiles file at: " + file.getAbsolutePath(), ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static Map<String, Profile> loadProfiles(InputStream is, ProfileCredentialsService profileCredentialsService) throws IOException {
        ProfilesConfigFileLoaderHelper helper = new ProfilesConfigFileLoaderHelper();
        Map<String, Map<String, String>> allProfileProperties = helper.parseProfileProperties(new Scanner(is));
        LinkedHashMap<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();
        for (Map.Entry<String, Map<String, String>> entry : allProfileProperties.entrySet()) {
            String profileName = entry.getKey();
            Map<String, String> properties = entry.getValue();
            if (profileName.startsWith("profile ")) {
                LOG.warn("The legacy profile format requires the 'profile ' prefix before the profile name. The latest code does not require such prefix, and will consider it as part of the profile name. Please remove the prefix if you are seeing this warning.");
            }
            ProfilesConfigFileLoader.assertParameterNotEmpty(profileName, "Unable to load credentials into profile: ProfileName is empty.");
            if (properties.containsKey("role_arn")) {
                profilesByName.put(profileName, ProfilesConfigFileLoader.fromAssumeRole(profileName, properties, allProfileProperties, profileCredentialsService));
                continue;
            }
            profilesByName.put(profileName, ProfilesConfigFileLoader.fromStaticCredentials(profileName, properties));
        }
        return profilesByName;
    }

    private static Profile fromStaticCredentials(String profileName, Map<String, String> properties) {
        String accessKey = properties.get("aws_access_key_id");
        String secretKey = properties.get("aws_secret_access_key");
        String sessionToken = properties.get("aws_session_token");
        if (StringUtils.isNullOrEmpty(accessKey)) {
            throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Access Key ID is not specified.", profileName));
        }
        if (StringUtils.isNullOrEmpty(secretKey)) {
            throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Secret Access Key is not specified.", profileName));
        }
        if (sessionToken == null) {
            return new Profile(profileName, new BasicAWSCredentials(accessKey, secretKey));
        }
        if (sessionToken.isEmpty()) {
            throw new AmazonClientException(String.format("Unable to load credentials into profile [%s]: AWS Session Token is empty.", profileName));
        }
        return new Profile(profileName, new BasicSessionCredentials(accessKey, secretKey, sessionToken));
    }

    private static Profile fromAssumeRole(String profileName, Map<String, String> properties, Map<String, Map<String, String>> allProfileProperties, ProfileCredentialsService profileCredentialsService) {
        String roleArn = properties.get("role_arn");
        String sourceProfileName = properties.get("source_profile");
        String roleSessionName = properties.get("role_session_name");
        String externalId = properties.get("external_id");
        if (StringUtils.isNullOrEmpty(sourceProfileName)) {
            return Profile.createInvalidProfile(profileName, String.format("Unable to load credentials into profile [%s]: Source profile name is not specified", profileName));
        }
        Map<String, String> sourceProfileProperties = allProfileProperties.get(sourceProfileName);
        if (sourceProfileProperties == null) {
            return Profile.createInvalidProfile(profileName, String.format("Unable to load source profile [%s]: Source profile not found [%s]", profileName, sourceProfileName));
        }
        String sourceAccessKey = sourceProfileProperties.get("aws_access_key_id");
        String sourceSecretKey = sourceProfileProperties.get("aws_secret_access_key");
        String sourceSessionToken = sourceProfileProperties.get("aws_session_token");
        if (StringUtils.isNullOrEmpty(sourceAccessKey)) {
            return Profile.createInvalidProfile(profileName, String.format("Unable to load credentials into profile [%s]: AWS Access Key ID is not specified in source profile [%s].", profileName, sourceProfileName));
        }
        if (StringUtils.isNullOrEmpty(sourceSecretKey)) {
            return Profile.createInvalidProfile(profileName, String.format("Unable to load credentials into profile [%s]: AWS Secret Access Key is not specified in source profile [%s].", profileName, sourceProfileName));
        }
        AWSCredentials sourceCredentials = StringUtils.isNullOrEmpty(sourceSessionToken) ? new BasicAWSCredentials(sourceAccessKey, sourceSecretKey) : new BasicSessionCredentials(sourceAccessKey, sourceSecretKey, sourceSessionToken);
        if (StringUtils.isNullOrEmpty(roleSessionName)) {
            roleSessionName = "aws-sdk-java-" + System.currentTimeMillis();
        }
        RoleInfo roleInfo = new RoleInfo().withRoleArn(roleArn).withRoleSessionName(roleSessionName).withExternalId(externalId).withLongLivedCredentials(sourceCredentials);
        return new Profile(profileName, sourceProfileName, profileCredentialsService.getAssumeRoleCredentialsProvider(roleInfo), roleInfo);
    }

    private static void assertParameterNotEmpty(String parameterValue, String errorMessage) {
        if (StringUtils.isNullOrEmpty(parameterValue)) {
            throw new AmazonClientException(errorMessage);
        }
    }

    private static class ProfilesConfigFileLoaderHelper
    extends AbstractProfilesConfigFileScanner {
        protected final Map<String, Map<String, String>> allProfileProperties = new LinkedHashMap<String, Map<String, String>>();

        private ProfilesConfigFileLoaderHelper() {
        }

        public Map<String, Map<String, String>> parseProfileProperties(Scanner scanner) {
            this.allProfileProperties.clear();
            this.run(scanner);
            return new LinkedHashMap<String, Map<String, String>>(this.allProfileProperties);
        }

        @Override
        protected void onEmptyOrCommentLine(String profileName, String line) {
        }

        @Override
        protected void onProfileStartingLine(String newProfileName, String line) {
            this.allProfileProperties.put(newProfileName, new HashMap());
        }

        @Override
        protected void onProfileEndingLine(String prevProfileName) {
        }

        @Override
        protected void onProfileProperty(String profileName, String propertyKey, String propertyValue, boolean isSupportedProperty, String line) {
            Map<String, String> properties;
            if (!isSupportedProperty) {
                LOG.info(String.format("Skip unsupported property name %s in profile [%s].", propertyKey, profileName));
                return;
            }
            if (this.allProfileProperties.get(profileName) == null) {
                this.allProfileProperties.put(profileName, new HashMap());
            }
            if ((properties = this.allProfileProperties.get(profileName)).containsKey(propertyKey)) {
                throw new IllegalArgumentException("Duplicate property values for [" + propertyKey + "].");
            }
            properties.put(propertyKey, propertyValue);
        }

        @Override
        protected void onEndOfFile() {
        }
    }
}

