/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.duracloud.sync.mgmt.ChangedFile;
import org.duracloud.sync.mgmt.ChangedListListener;
import org.duracloud.sync.mgmt.FileExclusionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedList
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChangedList.class);
    private LinkedHashMap<String, ChangedFile> fileList = new LinkedHashMap();
    private LinkedHashMap<String, ChangedFile> reservedFiles = new LinkedHashMap();
    private ExecutorService executorService;
    private long listVersion = 0L;
    private boolean shutdown = false;
    private static ChangedList instance;
    private FileExclusionManager fileExclusionManager = new FileExclusionManager();
    private EventListenerSupport<ChangedListListener> listeners = new EventListenerSupport(ChangedListListener.class);

    public static synchronized ChangedList getInstance() {
        if (instance == null) {
            instance = new ChangedList();
        }
        return instance;
    }

    private ChangedList() {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void setFileExclusionManager(FileExclusionManager fileExclusionManager) {
        if (fileExclusionManager == null) {
            throw new IllegalArgumentException("fileExclusionManager must not be null");
        }
        this.fileExclusionManager = fileExclusionManager;
    }

    public boolean addChangedFile(File changedFile) {
        if (null != changedFile) {
            return this.addChangedFile(new ChangedFile(changedFile));
        }
        log.warn("The changedFile parameter was unexpectedly null. Ignored.");
        return false;
    }

    public int getListSize() {
        return this.fileList.size();
    }

    public int getListSizeIncludingReservedFiles() {
        return this.fileList.size() + this.reservedFiles.size();
    }

    synchronized boolean addChangedFile(ChangedFile changedFile) {
        File file = changedFile.getFile();
        if (this.fileExclusionManager.isExcluded(file)) {
            return false;
        }
        this.fileList.put(file.getAbsolutePath(), changedFile);
        this.incrementVersion();
        this.fireChangedEvent();
        return true;
    }

    protected void fireChangedEvent() {
        ((ChangedListListener)this.listeners.fire()).listChanged(this);
    }

    protected void fireChangedEventAsync() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                ChangedList.this.fireChangedEvent();
            }
        });
    }

    public void addListener(ChangedListListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeListener(ChangedListListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public synchronized void clear() {
        this.fileList.clear();
        this.reservedFiles.clear();
        this.fireChangedEvent();
    }

    public synchronized ChangedFile reserve() {
        if (this.fileList.isEmpty() || this.shutdown) {
            return null;
        }
        String key = this.fileList.keySet().iterator().next();
        ChangedFile changedFile = (ChangedFile)this.fileList.remove(key);
        this.reservedFiles.put(key, changedFile);
        this.incrementVersion();
        this.fireChangedEventAsync();
        return changedFile;
    }

    private void incrementVersion() {
        this.listVersion = this.listVersion < Long.MAX_VALUE ? ++this.listVersion : 0L;
    }

    public long getVersion() {
        return this.listVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long persist(File persistFile) {
        try {
            long persistVersion;
            Map fileListCopy;
            FileOutputStream fileStream = new FileOutputStream(persistFile);
            ObjectOutputStream oStream = new ObjectOutputStream(fileStream);
            ChangedList changedList = this;
            synchronized (changedList) {
                fileListCopy = (Map)this.fileList.clone();
                fileListCopy.putAll(this.reservedFiles);
                persistVersion = this.listVersion;
            }
            oStream.writeObject(fileListCopy);
            oStream.close();
            return persistVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to persist File Changed List:" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restore(File persistFile, List<File> contentDirs) {
        try {
            FileInputStream fileStream = new FileInputStream(persistFile);
            ObjectInputStream oStream = new ObjectInputStream(fileStream);
            log.info("Restoring changed list from backup: {}", (Object)persistFile.getAbsolutePath());
            ChangedList changedList = this;
            synchronized (changedList) {
                LinkedHashMap fileListFromDisk = (LinkedHashMap)oStream.readObject();
                if (contentDirs != null && !contentDirs.isEmpty()) {
                    Iterator entries = fileListFromDisk.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry entry = entries.next();
                        ChangedFile file = (ChangedFile)entry.getValue();
                        boolean watched = false;
                        for (File contentDir : contentDirs) {
                            if (!file.getFile().getAbsolutePath().startsWith(contentDir.getAbsolutePath()) || this.fileExclusionManager.isExcluded(file.getFile())) continue;
                            watched = true;
                            break;
                        }
                        if (watched) continue;
                        entries.remove();
                    }
                }
                this.fileList = fileListFromDisk;
            }
            oStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to restore File Changed List:" + e.getMessage(), e);
        }
    }

    public synchronized List<File> peek(int maxFiles) {
        LinkedList<File> files = new LinkedList<File>();
        Iterator<Map.Entry<String, ChangedFile>> it = this.fileList.entrySet().iterator();
        for (int count = 0; it.hasNext() && count < maxFiles; ++count) {
            files.add(it.next().getValue().getFile());
        }
        return files;
    }

    synchronized void remove(ChangedFile changedFile) {
        this.reservedFiles.remove(this.getKey(changedFile));
    }

    synchronized void unreserve(ChangedFile changedFile) {
        ChangedFile removedFile = (ChangedFile)this.reservedFiles.remove(this.getKey(changedFile));
        if (removedFile != null && !this.fileList.containsKey(this.getKey(removedFile))) {
            this.addChangedFile(removedFile);
        }
    }

    private String getKey(ChangedFile changedFile) {
        return changedFile.getFile().getAbsolutePath();
    }

    public void shutdown() {
        this.executorService.shutdown();
        this.shutdown = true;
    }
}

