/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.walker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.FileExclusionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirWalker
extends DirectoryWalker
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(DirWalker.class);
    private static DirWalker dirWalker;
    private boolean continueWalk;
    private List<File> filesAndDirs;
    protected final ChangedList changedList;
    private int files = 0;
    private boolean complete = false;
    protected FileExclusionManager fileExclusionManager;

    protected DirWalker(List<File> filesAndDirs, FileExclusionManager fileExclusionManager) {
        this.filesAndDirs = filesAndDirs;
        this.changedList = ChangedList.getInstance();
        this.fileExclusionManager = fileExclusionManager;
    }

    @Override
    public void run() {
        this.walkDirs();
    }

    public void stopWalk() {
        this.continueWalk = false;
    }

    protected void walkDirs() {
        try {
            this.continueWalk = true;
            for (File item : this.filesAndDirs) {
                if (null != item && item.exists() && this.continueWalk) {
                    if (item.isDirectory()) {
                        try {
                            ArrayList results = new ArrayList();
                            this.walk(item, results);
                            continue;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error walking directory " + item.getAbsolutePath() + ":" + e.getMessage(), e);
                        }
                    }
                    this.handleFile(item, 0, null);
                    continue;
                }
                String filename = "null";
                if (item != null) {
                    filename = item.getAbsolutePath();
                }
                if (!this.continueWalk) {
                    this.logger.info("Walk discontinued. Exiting walkDirs routine...");
                    break;
                }
                this.logger.warn("Skipping " + filename + ", as it does not exist");
            }
            this.logger.info("Found " + this.files + " files to sync in initial directory walk");
        }
        catch (Exception e) {
            this.logger.error("dir walker failed: " + e.getMessage(), (Throwable)e);
        }
        this.complete = true;
    }

    protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
        return !this.fileExclusionManager.isExcluded(directory);
    }

    protected void handleFile(File file, int depth, Collection results) {
        if (null == file) {
            this.logger.warn("The file parameter is unexpectedly null. Ignoring...");
        } else if (!this.fileExclusionManager.isExcluded(file) && this.changedList.addChangedFile(file)) {
            ++this.files;
        }
    }

    protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
        return !this.continueWalk;
    }

    public static DirWalker start(List<File> topDirs, FileExclusionManager fileExclusionManager) {
        dirWalker = new DirWalker(topDirs, fileExclusionManager);
        new Thread(dirWalker).start();
        return dirWalker;
    }

    public boolean walkComplete() {
        return this.complete;
    }

    public int getFilesCount() {
        return this.files;
    }
}

