/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import org.apache.commons.lang3.StringUtils;
import org.duracloud.sync.endpoint.EndPointListener;
import org.duracloud.sync.endpoint.SyncResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndPointLogger
implements EndPointListener {
    private Logger log = LoggerFactory.getLogger((String)"history-log");

    @Override
    public void contentBackedUp(String storeId, String spaceId, String contentId, String backupContentId, String localFilePath) {
        this.log.info(this.format(new Object[]{SyncResultType.BACKED_UP, storeId, spaceId, contentId, localFilePath, "back up copy: " + backupContentId}));
    }

    private String format(Object[] objects) {
        return StringUtils.join((Object[])objects, (String)"\t");
    }

    @Override
    public void contentAdded(String storeId, String spaceId, String contentId, String localFilePath) {
        this.log.info(this.format(new Object[]{SyncResultType.ADDED, storeId, spaceId, contentId, localFilePath}));
    }

    @Override
    public void contentUpdated(String storeId, String spaceId, String contentId, String localFilePath) {
        this.log.info(this.format(new Object[]{SyncResultType.UPDATED, storeId, spaceId, contentId, localFilePath}));
    }

    @Override
    public void contentDeleted(String storeId, String spaceId, String contentId) {
        this.log.info(this.format(new Object[]{SyncResultType.DELETED, storeId, spaceId, contentId}));
    }

    @Override
    public void contentUpdateIgnored(String storeId, String spaceId, String contentId, String localFilePath) {
        this.log.info(this.format(new Object[]{SyncResultType.UPDATE_IGNORED, storeId, spaceId, contentId, localFilePath, "local content changed but was not uploaded"}));
    }
}

