/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.monitor;

import java.io.File;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.duracloud.sync.mgmt.ChangedList;

public class DirectoryListener
extends FileAlterationListenerAdaptor {
    private ChangedList changedList = ChangedList.getInstance();
    private boolean syncDeletes;

    public DirectoryListener(boolean syncDeletes) {
        this.syncDeletes = syncDeletes;
    }

    public void onFileCreate(File file) {
        this.addFileToChangedList(file);
    }

    public void onFileChange(File file) {
        this.addFileToChangedList(file);
    }

    public void onFileDelete(File file) {
        if (this.syncDeletes) {
            this.addFileToChangedList(file);
        }
    }

    private void addFileToChangedList(File file) {
        this.changedList.addChangedFile(file);
    }
}

