/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.util;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;

public class DirectoryUtil {
    private DirectoryUtil() {
    }

    public static File[] listFilesSortedByModDate(File dir) {
        File[] backupDirFiles = dir.listFiles();
        Arrays.sort(backupDirFiles, new FileComparator());
        return backupDirFiles;
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            if (file1.lastModified() == file2.lastModified()) {
                return 0;
            }
            return FileUtils.isFileNewer((File)file1, (File)file2) ? -1 : 1;
        }
    }
}

