/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.duracloud.chunk.FileChunker;
import org.duracloud.chunk.FileChunkerOptions;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.chunk.util.ChunksManifestVerifier;
import org.duracloud.chunk.writer.ContentWriter;
import org.duracloud.chunk.writer.DuracloudContentWriter;
import org.duracloud.client.ContentStore;
import org.duracloud.common.retry.Retrier;
import org.duracloud.domain.Content;
import org.duracloud.error.ContentStoreException;
import org.duracloud.stitch.FileStitcher;
import org.duracloud.stitch.datasource.DataSource;
import org.duracloud.stitch.datasource.impl.DuraStoreDataSource;
import org.duracloud.stitch.impl.FileStitcherImpl;
import org.duracloud.sync.endpoint.ChunkFilteredIterator;
import org.duracloud.sync.endpoint.DuraStoreSyncEndpoint;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuraStoreChunkSyncEndpoint
extends DuraStoreSyncEndpoint {
    private final Logger log = LoggerFactory.getLogger(DuraStoreChunkSyncEndpoint.class);
    private FileStitcher stitcher;
    private boolean jumpStart;
    private FileChunkerOptions chunkerOptions;

    public DuraStoreChunkSyncEndpoint(ContentStore contentStore, String username, String spaceId, boolean syncDeletes, boolean jumpStart, long maxFileSize) {
        this(contentStore, username, spaceId, syncDeletes, maxFileSize, true, false, jumpStart, ".orig", null);
    }

    public DuraStoreChunkSyncEndpoint(ContentStore contentStore, String username, String spaceId, boolean syncDeletes, long maxFileSize, boolean syncUpdates, boolean renameUpdates, boolean jumpStart, String updateSuffix, String prefix) {
        super(contentStore, username, spaceId, syncDeletes, syncUpdates, renameUpdates, jumpStart, updateSuffix, prefix);
        if (maxFileSize % 1000L != 0L) {
            throw new RuntimeException("Max file size must be factor of 1000");
        }
        this.jumpStart = jumpStart;
        this.chunkerOptions = new FileChunkerOptions(maxFileSize);
        this.stitcher = new FileStitcherImpl((DataSource)new DuraStoreDataSource(contentStore));
    }

    @Override
    protected Map<String, String> getContentProperties(String spaceId, String contentId) {
        Map<String, String> props = super.getContentProperties(spaceId, contentId);
        if (null == props) {
            try {
                ChunksManifest manifest = this.stitcher.getManifest(spaceId, this.getManifestId(contentId));
                if (this.chunksInDuraCloudMatchChunksInManifest(spaceId, manifest)) {
                    props = this.getManifestProperties(spaceId, manifest);
                }
            }
            catch (Exception ex) {
                this.log.debug("Not a chunked content item: {}/{}", (Object)spaceId, (Object)contentId);
            }
        }
        return props;
    }

    private boolean chunksInDuraCloudMatchChunksInManifest(String spaceId, ChunksManifest manifest) {
        try {
            ChunksManifestVerifier verifier = new ChunksManifestVerifier(this.getContentStore());
            return verifier.verifyAllChunks(spaceId, manifest).isSuccess();
        }
        catch (Exception e) {
            this.log.warn("chunked file does not exist or is not valid: {}/{}", (Object)spaceId, (Object)manifest.getManifestId());
            return false;
        }
    }

    private Map<String, String> getManifestProperties(String spaceId, ChunksManifest manifest) {
        Map props = null;
        String manifestId = manifest.getManifestId();
        try {
            Content manifesContentItem = this.stitcher.getContentFromManifest(spaceId, manifestId);
            props = manifesContentItem.getProperties();
            this.log.info("Manifest found for content: {}/{}", (Object)spaceId, (Object)manifestId);
        }
        catch (Exception e) {
            this.log.debug("Not a chunked content item: {}/{}", (Object)spaceId, (Object)manifestId);
        }
        return props;
    }

    protected String getManifestId(String contentId) {
        String manifestId = contentId + ".dura-manifest";
        return manifestId;
    }

    @Override
    public void deleteContent(String spaceId, String contentId) throws ContentStoreException {
        boolean contentDeleted = true;
        try {
            super.deleteContent(spaceId, contentId);
        }
        catch (ContentStoreException e) {
            contentDeleted = false;
        }
        if (!contentDeleted) {
            this.log.debug("Maybe content was chunked? {}/{}", (Object)spaceId, (Object)contentId);
            ChunksManifest manifest = this.getManifest(spaceId, contentId);
            if (null != manifest) {
                String manifestId = manifest.getManifestId();
                this.log.info("Deleting all chunks in manifest, {}", (Object)manifestId);
                for (ChunksManifestBean.ManifestEntry entry : manifest.getEntries()) {
                    super.deleteContent(spaceId, entry.getChunkId());
                }
                this.log.info("Deleting manifest: {}/{}", (Object)spaceId, (Object)manifestId);
                super.deleteContent(spaceId, manifestId);
            }
        }
    }

    private ChunksManifest getManifest(String spaceId, String contentId) {
        String manifestId = this.getManifestId(contentId);
        ChunksManifest manifest = null;
        try {
            manifest = this.stitcher.getManifest(spaceId, manifestId);
        }
        catch (Exception e) {
            this.log.info("No manifest for item: {}/{}", (Object)spaceId, (Object)contentId);
        }
        return manifest;
    }

    @Override
    protected void addUpdateContent(String contentId, MonitoredFile syncFile) {
        Map<String, String> properties = this.createProps(syncFile.getAbsolutePath(), this.getUsername());
        ContentStore store = this.getContentStore();
        DuracloudContentWriter contentWriter = new DuracloudContentWriter(store, this.getUsername(), true, this.jumpStart);
        FileChunker chunker = new FileChunker((ContentWriter)contentWriter, this.chunkerOptions);
        String spaceId = this.getSpaceId();
        chunker.addContent(spaceId, contentId, syncFile.getChecksum(), syncFile.length(), (InputStream)syncFile.getStream(), properties);
        this.cleanup(contentId, syncFile, store, spaceId);
    }

    private void cleanup(String contentId, MonitoredFile syncFile, ContentStore store, String spaceId) {
        try {
            new Retrier().execute(() -> {
                this.log.debug("checking for chunks, manifests, and/or unchunked files that should be removed : for {}/{}", (Object)spaceId, (Object)contentId);
                Iterator chunkedContentIdIt = store.getSpaceContents(this.getSpaceId(), contentId + ".dura-");
                HashSet chunkedContentIds = new HashSet();
                chunkedContentIdIt.forEachRemaining(id -> chunkedContentIds.add(id));
                if (!chunkedContentIds.isEmpty()) {
                    if (syncFile.length() <= this.chunkerOptions.getMaxChunkSize()) {
                        this.log.info("A chunked version was replaced by an unchunked version of {}/{}", (Object)spaceId, (Object)contentId);
                        chunkedContentIds.stream().forEach(content -> this.deleteContent(spaceId, (String)content, store));
                        this.log.info("Deleted manifest and all chunks associated with {}/{} because the chunked file was replaced by an unchunked file with the same name.", (Object)spaceId, (Object)contentId);
                    } else {
                        this.log.debug("Checking for orphaned chunks associated with {}/{}", (Object)spaceId, (Object)contentId);
                        ChunksManifest manifest = this.getManifest(spaceId, contentId);
                        HashSet manifestChunks = new HashSet();
                        manifest.getEntries().stream().forEach(entry -> manifestChunks.add(entry.getChunkId()));
                        chunkedContentIds.stream().filter(chunkedContentId -> !chunkedContentId.endsWith(".dura-manifest")).forEach(chunk -> {
                            if (!manifestChunks.contains(chunk)) {
                                this.log.debug("Chunk not found in manifest: deleting orphaned chunk ({}/{})", (Object)spaceId, chunk);
                                this.deleteContent(spaceId, (String)chunk, store);
                            }
                        });
                        if (store.contentExists(spaceId, contentId)) {
                            this.deleteContent(spaceId, contentId, store);
                        }
                    }
                }
                return null;
            });
        }
        catch (Exception ex) {
            this.log.error(MessageFormat.format("Cleanup failed for  ({0}/{1})", spaceId, contentId), (Throwable)ex);
        }
    }

    private void deleteContent(String spaceId, String contentId, ContentStore store) {
        try {
            store.deleteContent(spaceId, contentId);
            this.log.debug("Deleted content  ({}/{})", (Object)spaceId, (Object)contentId);
        }
        catch (Exception ex) {
            String message = MessageFormat.format("Failed to delete content ({0}/{1}) due to {2}. As this is a non-critical failure, processing will continue on.", spaceId, contentId, ex.getMessage());
            this.log.error(message, (Throwable)ex);
        }
    }

    @Override
    public Iterator<String> getFilesList() {
        return new ChunkFilteredIterator(super.getFilesList());
    }
}

