/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.duracloud.sync.config.SyncToolConfig;
import org.duracloud.syncui.config.SyncUIConfig;
import org.duracloud.syncui.domain.DirectoryConfig;
import org.duracloud.syncui.domain.DirectoryConfigs;
import org.duracloud.syncui.domain.DuracloudConfiguration;
import org.duracloud.syncui.service.SyncConfigurationManager;
import org.duracloud.syncui.service.SyncToolConfigSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="syncConfigurationManager")
public class SyncConfigurationManagerImpl
implements SyncConfigurationManager {
    private static Logger log = LoggerFactory.getLogger(SyncConfigurationManagerImpl.class);
    private SyncToolConfig syncToolConfig;
    private String configXmlPath;

    public SyncConfigurationManagerImpl() {
        String configPath = SyncUIConfig.getConfigPath();
        this.setConfigXmlPath(configPath);
        this.initializeSyncToolConfig();
    }

    private void persistSyncToolConfig() throws RuntimeException {
        try {
            SyncToolConfigSerializer.serialize(this.syncToolConfig, this.getSyncToolConfigXmlPath());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeSyncToolConfig() {
        try {
            this.syncToolConfig = SyncToolConfigSerializer.deserialize(this.getSyncToolConfigXmlPath());
        }
        catch (IOException ex) {
            log.warn("unable to deserialize sync config : " + ex.getMessage());
            log.info("creating new config...");
            this.syncToolConfig = new SyncToolConfig();
            this.initializeDefaultValues();
        }
    }

    private void initializeDefaultValues() {
        this.syncToolConfig.setContext("durastore");
        this.syncToolConfig.setExitOnCompletion(false);
        this.syncToolConfig.setSyncDeletes(false);
        ArrayList<File> dirs = new ArrayList<File>();
        this.syncToolConfig.setContentDirs(dirs);
    }

    private String getSyncToolConfigXmlPath() {
        return this.configXmlPath;
    }

    @Override
    public void persistDuracloudConfiguration(String username, String password, String host, String port, String spaceId) {
        this.syncToolConfig.setUsername(username);
        this.syncToolConfig.setPassword(password);
        this.syncToolConfig.setHost(host);
        this.syncToolConfig.setPort(Integer.parseInt(port));
        this.syncToolConfig.setSpaceId(spaceId);
        this.persistSyncToolConfig();
    }

    @Override
    public DuracloudConfiguration retrieveDuracloudConfiguration() {
        SyncToolConfig s = this.syncToolConfig;
        return new DuracloudConfiguration(s.getUsername(), s.getPassword(), s.getHost(), s.getPort(), s.getSpaceId());
    }

    @Override
    public DirectoryConfigs retrieveDirectoryConfigs() {
        DirectoryConfigs c = new DirectoryConfigs();
        List<File> dirs = this.syncToolConfig.getContentDirs();
        for (File f : dirs) {
            c.add(new DirectoryConfig(f.getAbsolutePath()));
        }
        return c;
    }

    @Override
    public void persistDirectoryConfigs(DirectoryConfigs configs) {
        LinkedList<File> dirs = new LinkedList<File>();
        for (DirectoryConfig f : configs) {
            dirs.add(new File(f.getDirectoryPath()));
        }
        this.syncToolConfig.setContentDirs(dirs);
        this.persistSyncToolConfig();
    }

    @Override
    public boolean isConfigurationComplete() {
        SyncToolConfig c = this.syncToolConfig;
        if (c == null) {
            return false;
        }
        return !StringUtils.isBlank(c.getUsername()) && !StringUtils.isBlank(c.getUsername()) && !StringUtils.isBlank(c.getPassword()) && !StringUtils.isBlank(c.getHost()) && !StringUtils.isBlank(c.getSpaceId());
    }

    @Override
    public void setConfigXmlPath(String configXml) {
        if (this.configXmlPath != configXml) {
            this.configXmlPath = configXml;
            this.initializeSyncToolConfig();
        }
        log.info("xml config path set to {}", (Object)this.configXmlPath);
    }

    @Override
    public void persist() {
        this.persistSyncToolConfig();
    }

    @Override
    public File getWorkDirectory() {
        return SyncUIConfig.getWorkDir();
    }

    @Override
    public void purgeWorkDirectory() {
        try {
            FileUtils.cleanDirectory(SyncUIConfig.getWorkDir());
        }
        catch (IOException e) {
            log.error("Unable to clean work directory due to: " + e.getMessage());
        }
    }

    @Override
    public boolean isSyncDeletes() {
        return this.syncToolConfig.syncDeletes();
    }

    @Override
    public void setSyncDeletes(boolean flag) {
        if (flag && this.syncToolConfig.isRenameUpdates()) {
            return;
        }
        this.syncToolConfig.setSyncDeletes(flag);
        this.persistSyncToolConfig();
    }

    @Override
    public String getUpdateSuffix() {
        return this.syncToolConfig.getUpdateSuffix();
    }

    @Override
    public void setSyncUpdates(boolean b) {
        this.syncToolConfig.setSyncUpdates(b);
        this.persistSyncToolConfig();
    }

    @Override
    public boolean isSyncUpdates() {
        return this.syncToolConfig.isSyncUpdates();
    }

    @Override
    public void setRenameUpdates(boolean b) {
        if (b && this.syncToolConfig.syncDeletes()) {
            return;
        }
        this.syncToolConfig.setRenameUpdates(b);
        this.persistSyncToolConfig();
    }

    @Override
    public boolean isRenameUpdates() {
        return this.syncToolConfig.isRenameUpdates();
    }

    @Override
    public String getPrefix() {
        return this.syncToolConfig.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) {
        this.syncToolConfig.setPrefix(prefix);
        this.persistSyncToolConfig();
    }

    @Override
    public int getThreadCount() {
        return this.syncToolConfig.getNumThreads();
    }

    @Override
    public void setThreadCount(int threadCount) {
        this.syncToolConfig.setNumThreads(threadCount);
        this.persistSyncToolConfig();
    }

    @Override
    public void setJumpStart(boolean jumpStart) {
        if (jumpStart && !this.syncToolConfig.isSyncUpdates() || jumpStart && this.syncToolConfig.isRenameUpdates()) {
            return;
        }
        this.syncToolConfig.setJumpStart(jumpStart);
        this.persistSyncToolConfig();
    }

    @Override
    public boolean isJumpStart() {
        return this.syncToolConfig.isJumpStart();
    }
}

