/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.model.Credential;
import org.duracloud.error.ContentStoreException;
import org.duracloud.sync.endpoint.DuraStoreChunkSyncEndpoint;
import org.duracloud.sync.endpoint.EndPointListener;
import org.duracloud.sync.endpoint.EndPointLogger;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.StatusManager;
import org.duracloud.sync.mgmt.SyncManager;
import org.duracloud.sync.mgmt.SyncSummary;
import org.duracloud.sync.monitor.DirectoryUpdateMonitor;
import org.duracloud.sync.walker.DeleteChecker;
import org.duracloud.sync.walker.DirWalker;
import org.duracloud.syncui.domain.DirectoryConfigs;
import org.duracloud.syncui.domain.DuracloudConfiguration;
import org.duracloud.syncui.domain.SyncProcessState;
import org.duracloud.syncui.domain.SyncProcessStats;
import org.duracloud.syncui.service.ContentStoreManagerFactory;
import org.duracloud.syncui.service.RuntimeStateMemento;
import org.duracloud.syncui.service.SyncConfigurationManager;
import org.duracloud.syncui.service.SyncOptimizeManager;
import org.duracloud.syncui.service.SyncProcessError;
import org.duracloud.syncui.service.SyncProcessException;
import org.duracloud.syncui.service.SyncProcessManager;
import org.duracloud.syncui.service.SyncProcessManagerImpl;
import org.duracloud.syncui.service.SyncProcessStateTransitionValidator;
import org.duracloud.syncui.service.SyncStateChangeListener;
import org.duracloud.syncui.service.SyncStateChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="syncProcessManager")
public class SyncProcessManagerImpl
implements SyncProcessManager {
    private static final int CHANGE_LIST_MONITOR_FREQUENCY = 5000;
    private static Logger log = LoggerFactory.getLogger(SyncProcessManagerImpl.class);
    private InternalState currentState;
    private SyncConfigurationManager syncConfigurationManager;
    private StoppedState stoppedState = new StoppedState(this, null);
    private StartingState startingState = new StartingState(this, null);
    private RunningState runningState = new RunningState(this, null);
    private StoppingState stoppingState = new StoppingState(this, null);
    private PausingState pausingState = new PausingState(this, null);
    private PausedState pausedState = new PausedState(this, null);
    private ResumingState resumingState = new ResumingState(this, null);
    private List<SyncStateChangeListener> listeners;
    private SyncProcessStateTransitionValidator syncProcessStateTransitionValidator;
    private SyncManager syncManager;
    private DirWalker dirWalker;
    private DirectoryUpdateMonitor dirMonitor;
    private DeleteChecker deleteChecker;
    private SyncProcessError error;
    private SyncOptimizeManager syncOptimizeManager;
    private ContentStoreManagerFactory contentStoreManagerFactory;
    private Date syncStartedDate = null;

    @Autowired
    public SyncProcessManagerImpl(SyncConfigurationManager syncConfigurationManager, ContentStoreManagerFactory contentStoreManagerFactory, SyncOptimizeManager syncOptimizeManager) {
        this.syncConfigurationManager = syncConfigurationManager;
        this.currentState = this.stoppedState;
        this.listeners = new ArrayList();
        this.syncProcessStateTransitionValidator = new SyncProcessStateTransitionValidator();
        this.contentStoreManagerFactory = contentStoreManagerFactory;
        this.syncOptimizeManager = syncOptimizeManager;
    }

    @PostConstruct
    public void init() {
        this.automaticallyRestartIfAppropriate();
    }

    protected void automaticallyRestartIfAppropriate() {
        RuntimeStateMemento m = RuntimeStateMemento.get();
        if (this.syncConfigurationManager.isConfigurationComplete() && SyncProcessState.RUNNING.equals((Object)m.getSyncProcessState())) {
            try {
                this.start();
            }
            catch (SyncProcessException e) {
                log.error("failed to automatically restart the sync process");
            }
        }
    }

    public SyncProcessError getError() {
        return this.error;
    }

    public void clearError() {
        this.error = null;
    }

    public void start() throws SyncProcessException {
        this.currentState.start();
    }

    public void resume() throws SyncProcessException {
        this.currentState.resume();
    }

    public void stop() {
        this.currentState.stop();
    }

    public void pause() {
        this.currentState.pause();
    }

    public void restart() {
        this.currentState.restart();
    }

    public SyncProcessState getProcessState() {
        return this.currentState.getProcessState();
    }

    public SyncProcessStats getProcessStats() {
        return this.currentState.getProcessStats();
    }

    public void addSyncStateChangeListener(SyncStateChangeListener syncStateChangeListener) {
        this.listeners.add(syncStateChangeListener);
    }

    public void removeSyncStateChangeListener(SyncStateChangeListener syncStateChangeListener) {
        this.listeners.remove(syncStateChangeListener);
    }

    private void fireStateChanged(SyncProcessState state) {
        SyncStateChangedEvent event = new SyncStateChangedEvent(state);
        ArrayList copy = new ArrayList(this.listeners);
        for (SyncStateChangeListener listener : copy) {
            listener.stateChanged(event);
        }
    }

    private synchronized void changeState(InternalState state) {
        SyncProcessState incoming;
        SyncProcessState current = this.currentState.getProcessState();
        boolean validStateChange = this.syncProcessStateTransitionValidator.validate(current, incoming = state.getProcessState());
        if (validStateChange) {
            this.currentState = state;
            this.persistState(this.currentState);
            this.fireStateChanged(this.currentState.getProcessState());
        }
    }

    private void persistState(InternalState currentState) {
        RuntimeStateMemento state = RuntimeStateMemento.get();
        state.setSyncProcessState(currentState.getProcessState());
        RuntimeStateMemento.persist((RuntimeStateMemento)state);
    }

    private void startImpl() throws SyncProcessException {
        if (this.syncOptimizeManager.isRunning()) {
            String errorMsg = "The transfer rate is currently being optimized.";
            this.setError(new SyncProcessError(errorMsg));
            return;
        }
        this.changeState((InternalState)this.startingState);
        this.syncStartedDate = new Date();
        this.setError(null);
        this.startAsynchronously();
    }

    private void startAsynchronously() {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void resumeImpl() throws SyncProcessException {
        this.changeState((InternalState)this.resumingState);
        this.startAsynchronously();
    }

    private void startSyncProcess() throws SyncProcessException {
        DirectoryConfigs directories = this.syncConfigurationManager.retrieveDirectoryConfigs();
        if (directories.isEmpty()) {
            throw new SyncProcessException("unable to start because no watch directories are configured.");
        }
        List dirs = directories.toFileList();
        DuracloudConfiguration dc = this.syncConfigurationManager.retrieveDuracloudConfiguration();
        try {
            ContentStoreManager csm = this.contentStoreManagerFactory.create();
            String username = dc.getUsername();
            String spaceId = dc.getSpaceId();
            csm.login(new Credential(username, dc.getPassword()));
            ContentStore contentStore = csm.getPrimaryContentStore();
            boolean syncDeletes = this.syncConfigurationManager.isSyncDeletes();
            String prefix = this.syncConfigurationManager.getPrefix();
            DuraStoreChunkSyncEndpoint syncEndpoint = new DuraStoreChunkSyncEndpoint(contentStore, username, spaceId, syncDeletes, 0x40000000L, this.syncConfigurationManager.isSyncUpdates(), this.syncConfigurationManager.isRenameUpdates(), this.syncConfigurationManager.isJumpStart(), this.syncConfigurationManager.getUpdateSuffix(), prefix);
            syncEndpoint.addEndPointListener((EndPointListener)new EndPointLogger());
            this.syncManager = new SyncManager(dirs, (SyncEndpoint)syncEndpoint, this.syncConfigurationManager.getThreadCount(), 5000L);
            this.syncManager.beginSync();
            this.dirWalker = DirWalker.start((List)dirs, null);
            this.dirMonitor = new DirectoryUpdateMonitor(dirs, 5000L, syncDeletes);
            this.dirMonitor.startMonitor();
            if (syncDeletes) {
                this.deleteChecker = DeleteChecker.start((SyncEndpoint)syncEndpoint, (String)spaceId, (List)dirs, (String)prefix);
            }
        }
        catch (ContentStoreException e) {
            String message = StringUtils.abbreviate((String)e.getMessage(), (int)100);
            this.handleStartupException(message, (Exception)((Object)e));
        }
        catch (Exception e) {
            String message = StringUtils.abbreviate((String)e.getMessage(), (int)100);
            this.handleStartupException(message, e);
        }
    }

    private void handleStartupException(String message, Exception e) throws SyncProcessException {
        log.error(message, (Throwable)e);
        this.setError(new SyncProcessError(message));
        this.shutdownSyncProcess();
        this.changeState((InternalState)this.stoppingState);
        this.changeState((InternalState)this.stoppedState);
        throw new SyncProcessException(message, (Throwable)e);
    }

    private void setError(SyncProcessError error) {
        this.error = error;
    }

    private SyncProcessStats getProcessStatsImpl() {
        int queueSize = ChangedList.getInstance().getListSize();
        int errorSize = StatusManager.getInstance().getFailed().size();
        return new SyncProcessStats(this.syncStartedDate, null, errorSize, 0L, 0L, queueSize);
    }

    private void shutdownSyncProcess() {
        if (this.syncManager != null) {
            this.syncManager.terminateSync();
        }
        try {
            this.dirMonitor.stopMonitor();
        }
        catch (Exception ex) {
            log.warn("stop monitor failed: " + ex.getMessage());
        }
        if (this.deleteChecker != null) {
            this.deleteChecker.stop();
        }
        if (this.dirWalker != null) {
            this.dirWalker.stopWalk();
        }
    }

    private void resetChangeList() {
        ChangedList.getInstance().clear();
    }

    private void stopImpl() {
        this.changeState((InternalState)this.stoppingState);
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
    }

    private void pauseImpl() {
        this.changeState((InternalState)this.pausingState);
        3 t = new /* Unavailable Anonymous Inner Class!! */;
        t.start();
    }

    public List<MonitoredFile> getMonitoredFiles() {
        if (this.syncManager != null) {
            return this.syncManager.getFilesInTransfer();
        }
        return new LinkedList<MonitoredFile>();
    }

    public List<SyncSummary> getFailures() {
        if (this.syncManager != null) {
            return StatusManager.getInstance().getFailed();
        }
        return new LinkedList<SyncSummary>();
    }

    public List<SyncSummary> getRecentlyCompleted() {
        if (this.syncManager != null) {
            return StatusManager.getInstance().getRecentlyCompleted();
        }
        return new LinkedList<SyncSummary>();
    }

    public List<File> getQueuedFiles() {
        return ChangedList.getInstance().peek(10);
    }

    public void clearFailures() {
        StatusManager.getInstance().clearFailed();
    }

    static /* synthetic */ void access$700(SyncProcessManagerImpl x0) throws SyncProcessException {
        x0.startSyncProcess();
    }

    static /* synthetic */ RunningState access$800(SyncProcessManagerImpl x0) {
        return x0.runningState;
    }

    static /* synthetic */ void access$900(SyncProcessManagerImpl x0, InternalState x1) {
        x0.changeState(x1);
    }

    static /* synthetic */ Logger access$1000() {
        return log;
    }

    static /* synthetic */ StoppingState access$1100(SyncProcessManagerImpl x0) {
        return x0.stoppingState;
    }

    static /* synthetic */ StoppedState access$1200(SyncProcessManagerImpl x0) {
        return x0.stoppedState;
    }

    static /* synthetic */ void access$1300(SyncProcessManagerImpl x0) {
        x0.shutdownSyncProcess();
    }

    static /* synthetic */ Date access$1402(SyncProcessManagerImpl x0, Date x1) {
        x0.syncStartedDate = x1;
        return x0.syncStartedDate;
    }

    static /* synthetic */ SyncManager access$1500(SyncProcessManagerImpl x0) {
        return x0.syncManager;
    }

    static /* synthetic */ void access$1600(SyncProcessManagerImpl x0) {
        x0.resetChangeList();
    }

    static /* synthetic */ PausedState access$1700(SyncProcessManagerImpl x0) {
        return x0.pausedState;
    }

    static /* synthetic */ SyncProcessStats access$1800(SyncProcessManagerImpl x0) {
        return x0.getProcessStatsImpl();
    }

    static /* synthetic */ void access$2000(SyncProcessManagerImpl x0) throws SyncProcessException {
        x0.startImpl();
    }

    static /* synthetic */ void access$2100(SyncProcessManagerImpl x0) throws SyncProcessException {
        x0.resumeImpl();
    }

    static /* synthetic */ void access$2200(SyncProcessManagerImpl x0) {
        x0.stopImpl();
    }

    static /* synthetic */ void access$2300(SyncProcessManagerImpl x0) {
        x0.pauseImpl();
    }
}

