/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.ExitStandbyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ExitStandbyRequestMarshaller
implements Marshaller<Request<ExitStandbyRequest>, ExitStandbyRequest> {
    @Override
    public Request<ExitStandbyRequest> marshall(ExitStandbyRequest exitStandbyRequest) {
        if (exitStandbyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ExitStandbyRequest> request = new DefaultRequest<ExitStandbyRequest>(exitStandbyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "ExitStandby");
        request.addParameter("Version", "2011-01-01");
        List<String> instanceIdsList = exitStandbyRequest.getInstanceIds();
        int instanceIdsListIndex = 1;
        for (String instanceIdsListValue : instanceIdsList) {
            if (instanceIdsListValue != null) {
                request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
            }
            ++instanceIdsListIndex;
        }
        if (exitStandbyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(exitStandbyRequest.getAutoScalingGroupName()));
        }
        return request;
    }
}

