/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.services.machinelearning.model.CreateBatchPredictionRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRedshiftRequest;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromS3Request;
import com.amazonaws.services.machinelearning.model.CreateEvaluationRequest;
import com.amazonaws.services.machinelearning.model.CreateMLModelRequest;
import java.util.UUID;

public class RandomIdHandler
extends RequestHandler2 {
    @Override
    public AmazonWebServiceRequest beforeMarshalling(AmazonWebServiceRequest request) {
        if (request instanceof CreateBatchPredictionRequest) {
            CreateBatchPredictionRequest copy = (CreateBatchPredictionRequest)request;
            if (copy.getBatchPredictionId() == null) {
                copy = copy.clone();
                copy.setBatchPredictionId(UUID.randomUUID().toString());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromRDSRequest) {
            CreateDataSourceFromRDSRequest copy = (CreateDataSourceFromRDSRequest)request;
            if (copy.getDataSourceId() == null) {
                copy = copy.clone();
                copy.setDataSourceId(UUID.randomUUID().toString());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromRedshiftRequest) {
            CreateDataSourceFromRedshiftRequest copy = (CreateDataSourceFromRedshiftRequest)request;
            if (copy.getDataSourceId() == null) {
                copy = copy.clone();
                copy.setDataSourceId(UUID.randomUUID().toString());
            }
            return copy;
        }
        if (request instanceof CreateDataSourceFromS3Request) {
            CreateDataSourceFromS3Request copy = (CreateDataSourceFromS3Request)request;
            if (copy.getDataSourceId() == null) {
                copy = copy.clone();
                copy.setDataSourceId(UUID.randomUUID().toString());
            }
            return copy;
        }
        if (request instanceof CreateEvaluationRequest) {
            CreateEvaluationRequest copy = (CreateEvaluationRequest)request;
            if (copy.getEvaluationId() == null) {
                copy = copy.clone();
                copy.setEvaluationId(UUID.randomUUID().toString());
            }
            return copy;
        }
        if (request instanceof CreateMLModelRequest) {
            CreateMLModelRequest copy = (CreateMLModelRequest)request;
            if (copy.getMLModelId() == null) {
                copy = copy.clone();
                copy.setMLModelId(UUID.randomUUID().toString());
            }
            return copy;
        }
        return request;
    }

    @Override
    public void beforeRequest(Request<?> request) {
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception e) {
    }
}

