/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Configuration
implements Serializable,
Cloneable {
    private String classification;
    private ListWithAutoConstructFlag<Configuration> configurations;
    private Map<String, String> properties;

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public Configuration withClassification(String classification) {
        this.classification = classification;
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new ListWithAutoConstructFlag();
            this.configurations.setAutoConstruct(true);
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        ListWithAutoConstructFlag configurationsCopy = new ListWithAutoConstructFlag(configurations.size());
        configurationsCopy.addAll(configurations);
        this.configurations = configurationsCopy;
    }

    public Configuration withConfigurations(Configuration ... configurations) {
        if (this.getConfigurations() == null) {
            this.setConfigurations(new ArrayList<Configuration>(configurations.length));
        }
        for (Configuration value : configurations) {
            this.getConfigurations().add(value);
        }
        return this;
    }

    public Configuration withConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
        } else {
            ListWithAutoConstructFlag configurationsCopy = new ListWithAutoConstructFlag(configurations.size());
            configurationsCopy.addAll(configurations);
            this.configurations = configurationsCopy;
        }
        return this;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Configuration withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public Configuration addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public Configuration clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClassification() != null) {
            sb.append("Classification: " + this.getClassification() + ",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: " + this.getConfigurations() + ",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: " + this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClassification() == null ? 0 : this.getClassification().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (other.getClassification() == null ^ this.getClassification() == null) {
            return false;
        }
        if (other.getClassification() != null && !other.getClassification().equals(this.getClassification())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public Configuration clone() {
        try {
            return (Configuration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

