/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.core;

import java.util.ArrayList;
import java.util.List;

class AsyncStackTrace {
    private final StackTraceElement[] stackTrace;
    private final AsyncStackTrace parentTrace;
    private String startFrom;
    private boolean hideStartFromMethod;
    private final int skip;
    private static final boolean printRawTrace = false;

    public AsyncStackTrace(AsyncStackTrace parentTrace, StackTraceElement[] stackTrace, int skip) {
        this.parentTrace = parentTrace;
        this.stackTrace = stackTrace;
        this.skip = skip;
    }

    public StackTraceElement[] getStackTrace() {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        this.getStackTrace(result);
        return result.toArray(new StackTraceElement[0]);
    }

    private void getStackTrace(List<StackTraceElement> result) {
        int i = this.skip;
        while (i < this.stackTrace.length) {
            StackTraceElement element = this.stackTrace[i];
            if (i == this.skip && result.size() > 0) {
                StackTraceElement separator = new StackTraceElement("--- continuation ---", "", "", 0);
                result.add(separator);
            }
            if (this.startFrom != null && element.getMethodName().contains(this.startFrom)) {
                if (this.hideStartFromMethod) break;
                result.add(element);
                break;
            }
            result.add(element);
            ++i;
        }
        if (this.parentTrace != null) {
            this.parentTrace.getStackTrace(result);
        }
    }

    private StackTraceElement[] printRawTrace() {
        StackTraceElement[] parentStack;
        int parentLength;
        if (this.parentTrace != null && (parentLength = (parentStack = this.parentTrace.getStackTrace()).length) > 0) {
            StackTraceElement separator = new StackTraceElement("---continuation---", "", "", 0);
            StackTraceElement[] result = new StackTraceElement[this.stackTrace.length + parentLength + 1];
            System.arraycopy(this.stackTrace, 0, result, 0, this.stackTrace.length);
            result[this.stackTrace.length] = separator;
            System.arraycopy(parentStack, 0, result, this.stackTrace.length + 1, parentLength);
            return result;
        }
        return this.stackTrace;
    }

    public void setStartFrom(String startFrom) {
        this.startFrom = startFrom;
    }

    public void setHideStartFromMethod(boolean hideStartFromMethod) {
        this.hideStartFromMethod = hideStartFromMethod;
    }

    public String toString() {
        return this.stackTraceToString(this.getStackTrace());
    }

    private String stackTraceToString(StackTraceElement[] trace) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < trace.length) {
            if (i > 0) {
                result.append("\n\tat ");
            } else {
                result.append("\tat ");
            }
            result.append(trace[i]);
            ++i;
        }
        return result.toString();
    }
}

