/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class AddWorkingStorageRequestMarshaller
implements Marshaller<Request<AddWorkingStorageRequest>, AddWorkingStorageRequest> {
    @Override
    public Request<AddWorkingStorageRequest> marshall(AddWorkingStorageRequest addWorkingStorageRequest) {
        if (addWorkingStorageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddWorkingStorageRequest> request = new DefaultRequest<AddWorkingStorageRequest>(addWorkingStorageRequest, "AWSStorageGateway");
        String target = "StorageGateway_20130630.AddWorkingStorage";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag diskIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (addWorkingStorageRequest.getGatewayARN() != null) {
                jsonWriter.key("GatewayARN").value(addWorkingStorageRequest.getGatewayARN());
            }
            if (!((diskIdsList = (ListWithAutoConstructFlag)addWorkingStorageRequest.getDiskIds()) == null || diskIdsList.isAutoConstruct() && diskIdsList.isEmpty())) {
                jsonWriter.key("DiskIds");
                jsonWriter.array();
                for (String diskIdsListValue : diskIdsList) {
                    if (diskIdsListValue == null) continue;
                    jsonWriter.value(diskIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

