/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.queue.local;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.duracloud.common.queue.TaskException;
import org.duracloud.common.queue.TaskNotFoundException;
import org.duracloud.common.queue.TaskQueue;
import org.duracloud.common.queue.TimeoutException;
import org.duracloud.common.queue.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTaskQueue
implements TaskQueue {
    private Queue<Task> queue;
    private Logger log = LoggerFactory.getLogger(LocalTaskQueue.class);
    private List<Task> inprocess;
    private long completedCount = 0L;
    private String name = "local-task-queue-" + System.currentTimeMillis();

    @Override
    public String getName() {
        return this.name;
    }

    public LocalTaskQueue() {
        this.queue = new LinkedBlockingQueue<Task>();
        this.inprocess = new LinkedList<Task>();
    }

    @Override
    public synchronized void put(Task task) {
        this.queue.add(task);
    }

    @Override
    public synchronized void put(Task ... tasks) {
        HashSet<Task> taskSet = new HashSet<Task>();
        taskSet.addAll(Arrays.asList(tasks));
        this.put(taskSet);
    }

    @Override
    public synchronized void put(Set<Task> tasks) {
        this.queue.addAll(tasks);
    }

    @Override
    public synchronized Task take() throws TimeoutException {
        try {
            Task task = this.queue.remove();
            this.inprocess.add(task);
            return task;
        }
        catch (NoSuchElementException ex) {
            throw new TimeoutException(ex);
        }
    }

    @Override
    public void extendVisibilityTimeout(Task task) throws TaskNotFoundException {
        this.log.info("extending visibility time on {}", task);
    }

    @Override
    public synchronized void deleteTask(Task task) throws TaskNotFoundException {
        if (!this.inprocess.contains(task)) {
            this.log.error("{} not found.", task);
            throw new TaskNotFoundException("task not found:" + task.toString());
        }
        this.inprocess.remove(task);
        ++this.completedCount;
        this.log.info("{} complete", task);
    }

    @Override
    public Integer size() {
        return this.queue.size();
    }

    public int getInprocessCount() {
        return this.inprocess.size();
    }

    public long getCompletedCount() {
        return this.completedCount;
    }

    @Override
    public Integer sizeIncludingInvisibleAndDelayed() {
        return this.size();
    }

    @Override
    public void requeue(Task task) {
        this.inprocess.remove(task);
        task.incrementAttempts();
        this.queue.add(task);
    }

    @Override
    public void deleteTasks(Set<Task> tasks) throws TaskException {
        for (Task task : tasks) {
            this.deleteTask(task);
        }
    }

    @Override
    public Set<Task> take(int maxTasks) throws TimeoutException {
        HashSet<Task> set = new HashSet<Task>(1);
        set.add(this.take());
        return set;
    }
}

