/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.duracloud.client.ContentStore;
import org.duracloud.client.ContentStoreManager;
import org.duracloud.common.model.Credential;
import org.duracloud.error.ContentStoreException;
import org.duracloud.sync.backup.SyncBackupManager;
import org.duracloud.sync.endpoint.DuraStoreChunkSyncEndpoint;
import org.duracloud.sync.endpoint.EndPointLogger;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.ChangedListListener;
import org.duracloud.sync.mgmt.StatusManager;
import org.duracloud.sync.mgmt.SyncManager;
import org.duracloud.sync.mgmt.SyncSummary;
import org.duracloud.sync.monitor.DirectoryUpdateMonitor;
import org.duracloud.sync.walker.DeleteChecker;
import org.duracloud.sync.walker.DirWalker;
import org.duracloud.sync.walker.RestartDirWalker;
import org.duracloud.syncui.domain.DirectoryConfigs;
import org.duracloud.syncui.domain.DuracloudConfiguration;
import org.duracloud.syncui.domain.SyncProcessState;
import org.duracloud.syncui.domain.SyncProcessStats;
import org.duracloud.syncui.service.ContentStoreManagerFactory;
import org.duracloud.syncui.service.RunMode;
import org.duracloud.syncui.service.RuntimeStateMemento;
import org.duracloud.syncui.service.SyncConfigurationManager;
import org.duracloud.syncui.service.SyncOptimizeManager;
import org.duracloud.syncui.service.SyncProcess;
import org.duracloud.syncui.service.SyncProcessError;
import org.duracloud.syncui.service.SyncProcessException;
import org.duracloud.syncui.service.SyncProcessManager;
import org.duracloud.syncui.service.SyncProcessStateTransitionValidator;
import org.duracloud.syncui.service.SyncStateChangeListener;
import org.duracloud.syncui.service.SyncStateChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="syncProcessManager")
public class SyncProcessManagerImpl
implements SyncProcessManager {
    private static final int CHANGE_LIST_MONITOR_FREQUENCY = 5000;
    private static final int BACKUP_FREQUENCY = 300000;
    private static Logger log = LoggerFactory.getLogger(SyncProcessManagerImpl.class);
    private InternalState currentState;
    private SyncConfigurationManager syncConfigurationManager;
    private StoppedState stoppedState = new StoppedState();
    private StartingState startingState = new StartingState();
    private RunningState runningState = new RunningState();
    private StoppingState stoppingState = new StoppingState();
    private PausingState pausingState = new PausingState();
    private PausedState pausedState = new PausedState();
    private ResumingState resumingState = new ResumingState();
    private EventListenerSupport<SyncStateChangeListener> listeners;
    private SyncProcessStateTransitionValidator syncProcessStateTransitionValidator;
    private SyncManager syncManager;
    private DirWalker dirWalker;
    private DirectoryUpdateMonitor dirMonitor;
    private DeleteChecker deleteChecker;
    private SyncProcessError error;
    private SyncOptimizeManager syncOptimizeManager;
    private ContentStoreManagerFactory contentStoreManagerFactory;
    private Date syncStartedDate = null;
    private ChangedListListener changedListListener;
    private SyncBackupManager syncBackupManager;
    private File backupDir;

    @Autowired
    public SyncProcessManagerImpl(SyncConfigurationManager syncConfigurationManager, ContentStoreManagerFactory contentStoreManagerFactory, SyncOptimizeManager syncOptimizeManager) {
        this.syncConfigurationManager = syncConfigurationManager;
        this.currentState = this.stoppedState;
        this.listeners = new EventListenerSupport<SyncStateChangeListener>(SyncStateChangeListener.class);
        this.syncProcessStateTransitionValidator = new SyncProcessStateTransitionValidator();
        this.contentStoreManagerFactory = contentStoreManagerFactory;
        this.syncOptimizeManager = syncOptimizeManager;
        this.backupDir = new File(syncConfigurationManager.getWorkDirectory(), "backup");
        this.syncBackupManager = new SyncBackupManager(this.backupDir, 300000L, syncConfigurationManager.retrieveDirectoryConfigs().toFileList());
        this.changedListListener = new InternalChangedListListener();
        ChangedList.getInstance().addListener(this.changedListListener);
    }

    @PostConstruct
    public void init() {
        this.automaticallyRestartIfAppropriate();
    }

    protected void automaticallyRestartIfAppropriate() {
        RuntimeStateMemento m = RuntimeStateMemento.get();
        if (this.syncConfigurationManager.isConfigurationComplete() && SyncProcessState.RUNNING.equals((Object)m.getSyncProcessState())) {
            try {
                this.start();
            }
            catch (SyncProcessException e) {
                log.error("failed to automatically restart the sync process");
            }
        }
    }

    @Override
    public SyncProcessError getError() {
        return this.error;
    }

    @Override
    public void clearError() {
        this.error = null;
    }

    @Override
    public void start() throws SyncProcessException {
        this.currentState.start();
    }

    @Override
    public void resume() throws SyncProcessException {
        this.currentState.resume();
    }

    @Override
    public void stop() {
        this.currentState.stop();
    }

    @Override
    public void pause() {
        this.currentState.pause();
    }

    @Override
    public void restart() {
        this.currentState.restart();
    }

    @Override
    public SyncProcessState getProcessState() {
        return this.currentState.getProcessState();
    }

    @Override
    public SyncProcessStats getProcessStats() {
        return this.currentState.getProcessStats();
    }

    @Override
    public void addSyncStateChangeListener(SyncStateChangeListener syncStateChangeListener) {
        this.listeners.addListener(syncStateChangeListener);
    }

    @Override
    public void removeSyncStateChangeListener(SyncStateChangeListener syncStateChangeListener) {
        this.listeners.removeListener(syncStateChangeListener);
    }

    private void fireStateChanged(SyncProcessState state) {
        SyncStateChangedEvent event = new SyncStateChangedEvent(state);
        this.listeners.fire().stateChanged(event);
    }

    private synchronized void changeState(InternalState state) {
        SyncProcessState incoming;
        SyncProcessState current = this.currentState.getProcessState();
        boolean validStateChange = this.syncProcessStateTransitionValidator.validate(current, incoming = state.getProcessState());
        if (validStateChange) {
            this.currentState = state;
            this.persistState(this.currentState);
            this.fireStateChanged(this.currentState.getProcessState());
        }
    }

    private void persistState(InternalState currentState) {
        RuntimeStateMemento state = RuntimeStateMemento.get();
        state.setSyncProcessState(currentState.getProcessState());
        RuntimeStateMemento.persist(state);
    }

    private void startImpl() throws SyncProcessException {
        if (this.syncOptimizeManager.isRunning()) {
            String errorMsg = "The transfer rate is currently being optimized.";
            this.setError(new SyncProcessError(errorMsg));
            return;
        }
        this.changeState(this.startingState);
        this.syncStartedDate = new Date();
        this.setError(null);
        this.startAsynchronously();
    }

    private void startAsynchronously() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SyncProcessManagerImpl.this.startSyncProcess();
                    SyncProcessManagerImpl.this.changeState(SyncProcessManagerImpl.this.runningState);
                }
                catch (SyncProcessException e) {
                    log.error("start failed: " + e.getMessage(), e);
                    SyncProcessManagerImpl.this.changeState(SyncProcessManagerImpl.this.stoppingState);
                    SyncProcessManagerImpl.this.changeState(SyncProcessManagerImpl.this.stoppedState);
                }
            }
        }).start();
    }

    private void resumeImpl() throws SyncProcessException {
        this.changeState(this.resumingState);
        this.startAsynchronously();
    }

    private void startSyncProcess() throws SyncProcessException {
        DirectoryConfigs directories = this.syncConfigurationManager.retrieveDirectoryConfigs();
        if (directories.isEmpty()) {
            throw new SyncProcessException("unable to start because no watch directories are configured.");
        }
        List<File> dirs = directories.toFileList();
        DuracloudConfiguration dc = this.syncConfigurationManager.retrieveDuracloudConfiguration();
        try {
            ContentStoreManager csm = this.contentStoreManagerFactory.create();
            String username = dc.getUsername();
            String spaceId = dc.getSpaceId();
            csm.login(new Credential(username, dc.getPassword()));
            ContentStore contentStore = csm.getPrimaryContentStore();
            boolean syncDeletes = this.syncConfigurationManager.isSyncDeletes();
            String prefix = this.syncConfigurationManager.getPrefix();
            DuraStoreChunkSyncEndpoint syncEndpoint = new DuraStoreChunkSyncEndpoint(contentStore, username, spaceId, syncDeletes, this.syncConfigurationManager.getMaxFileSizeInBytes(), this.syncConfigurationManager.isSyncUpdates(), this.syncConfigurationManager.isRenameUpdates(), this.syncConfigurationManager.isJumpStart(), this.syncConfigurationManager.getUpdateSuffix(), prefix);
            syncEndpoint.addEndPointListener(new EndPointLogger());
            this.backupDir.mkdirs();
            this.syncBackupManager = new SyncBackupManager(this.backupDir, 300000L, dirs);
            long backup = -1L;
            if (this.syncBackupManager.hasBackups()) {
                backup = this.syncBackupManager.attemptRestart();
            }
            this.syncManager = new SyncManager(dirs, syncEndpoint, this.syncConfigurationManager.getThreadCount(), 5000L);
            this.syncManager.beginSync();
            RunMode mode = this.syncConfigurationManager.getMode();
            if (backup < 0L) {
                this.dirWalker = DirWalker.start(dirs, null);
            } else if (mode.equals((Object)RunMode.CONTINUOUS)) {
                this.dirWalker = RestartDirWalker.start(dirs, null, backup);
            }
            this.startBackupsOnDirWalkerCompletion();
            this.dirMonitor = new DirectoryUpdateMonitor(dirs, 5000L, syncDeletes);
            this.configureMode(mode);
            if (syncDeletes) {
                this.deleteChecker = DeleteChecker.start(syncEndpoint, spaceId, dirs, prefix);
            }
        }
        catch (ContentStoreException e) {
            String message = StringUtils.abbreviate(e.getMessage(), 100);
            this.handleStartupException(message, e);
        }
        catch (Exception e) {
            String message = StringUtils.abbreviate(e.getMessage(), 100);
            this.handleStartupException(message, e);
        }
    }

    private void startBackupsOnDirWalkerCompletion() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (SyncProcessManagerImpl.this.dirWalker != null && !SyncProcessManagerImpl.this.dirWalker.walkComplete()) {
                    SyncProcessManagerImpl.this.sleep(100L);
                }
                log.info("Starting back up manager...");
                SyncProcessManagerImpl.this.syncBackupManager.startupBackups();
            }
        }, "walk-completion-checker thread").start();
    }

    protected void sleep() {
        this.sleep(500L);
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void configureMode(RunMode mode) {
        try {
            if (mode.equals((Object)RunMode.CONTINUOUS)) {
                this.dirMonitor.startMonitor();
                ChangedList.getInstance().removeListener(this.changedListListener);
            } else {
                ChangedList.getInstance().addListener(this.changedListListener);
                this.dirMonitor.stopMonitor();
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    private void handleStartupException(String message, Exception e) throws SyncProcessException {
        log.error(message, e);
        this.setError(new SyncProcessError(message));
        this.shutdownSyncProcess();
        this.changeState(this.stoppingState);
        this.changeState(this.stoppedState);
        throw new SyncProcessException(message, e);
    }

    private void setError(SyncProcessError error) {
        this.error = error;
    }

    private SyncProcessStats getProcessStatsImpl() {
        int queueSize = ChangedList.getInstance().getListSize();
        int errorSize = StatusManager.getInstance().getFailed().size();
        return new SyncProcessStats(this.syncStartedDate, null, errorSize, 0L, 0L, queueSize);
    }

    private void shutdownSyncProcess() {
        if (this.syncManager != null) {
            this.syncManager.terminateSync();
        }
        try {
            if (this.dirMonitor != null) {
                this.dirMonitor.stopMonitor();
            }
        }
        catch (Exception ex) {
            log.warn("stop monitor failed: " + ex.getMessage());
        }
        if (this.deleteChecker != null) {
            this.deleteChecker.stop();
        }
        if (this.dirWalker != null) {
            this.dirWalker.stopWalk();
        }
    }

    private void resetChangeList() {
        ChangedList.getInstance().clear();
        this.syncBackupManager.endBackups();
        this.syncBackupManager.clearBackups();
    }

    private void stopImpl() {
        this.changeState(this.stoppingState);
        new Thread(){

            @Override
            public void run() {
                SyncProcessManagerImpl.this.shutdownSyncProcess();
                SyncProcessManagerImpl.this.syncStartedDate = null;
                while (!SyncProcessManagerImpl.this.syncManager.getFilesInTransfer().isEmpty()) {
                    SyncProcessManagerImpl.this.sleep();
                }
                SyncProcessManagerImpl.this.resetChangeList();
                SyncProcessManagerImpl.this.changeState(SyncProcessManagerImpl.this.stoppedState);
            }
        }.start();
    }

    private void pauseImpl() {
        this.changeState(this.pausingState);
        Thread t = new Thread(){

            @Override
            public void run() {
                SyncProcessManagerImpl.this.shutdownSyncProcess();
                SyncManager sm = SyncProcessManagerImpl.this.syncManager;
                while (!sm.getFilesInTransfer().isEmpty()) {
                    SyncProcessManagerImpl.this.sleep();
                }
                SyncProcessManagerImpl.this.changeState(SyncProcessManagerImpl.this.pausedState);
            }
        };
        t.start();
    }

    @Override
    public List<MonitoredFile> getMonitoredFiles() {
        SyncManager sm = this.syncManager;
        if (sm != null) {
            return sm.getFilesInTransfer();
        }
        return new LinkedList<MonitoredFile>();
    }

    @Override
    public List<SyncSummary> getFailures() {
        if (this.syncManager != null) {
            return StatusManager.getInstance().getFailed();
        }
        return new LinkedList<SyncSummary>();
    }

    @Override
    public List<SyncSummary> getRecentlyCompleted() {
        if (this.syncManager != null) {
            return StatusManager.getInstance().getRecentlyCompleted();
        }
        return new LinkedList<SyncSummary>();
    }

    @Override
    public List<File> getQueuedFiles() {
        return ChangedList.getInstance().peek(10);
    }

    @Override
    public void clearFailures() {
        StatusManager.getInstance().clearFailed();
    }

    @PreDestroy
    public void shutdown() {
        this.syncBackupManager.endBackups();
        ChangedList.getInstance().shutdown();
    }

    private class PausingState
    extends InternalState {
        private PausingState() {
        }

        @Override
        public SyncProcessState getProcessState() {
            return SyncProcessState.PAUSING;
        }
    }

    private class StoppingState
    extends InternalState {
        private StoppingState() {
        }

        @Override
        public SyncProcessState getProcessState() {
            return SyncProcessState.STOPPING;
        }
    }

    private class RunningState
    extends InternalState {
        private RunningState() {
        }

        @Override
        public void stop() {
            SyncProcessManagerImpl.this.stopImpl();
        }

        @Override
        public void pause() {
            SyncProcessManagerImpl.this.pauseImpl();
        }

        @Override
        public void restart() {
            SyncProcessManagerImpl.this.addSyncStateChangeListener(new SyncStateChangeListener(){

                @Override
                public void stateChanged(SyncStateChangedEvent event) {
                    if (event.getProcessState().equals((Object)SyncProcessState.STOPPED)) {
                        try {
                            SyncProcessManagerImpl.this.removeSyncStateChangeListener(this);
                            SyncProcessManagerImpl.this.startImpl();
                        }
                        catch (SyncProcessException e) {
                            log.warn(e.getMessage(), e);
                        }
                    }
                }
            });
            SyncProcessManagerImpl.this.stopImpl();
        }

        @Override
        public SyncProcessState getProcessState() {
            return SyncProcessState.RUNNING;
        }
    }

    private class ResumingState
    extends InternalState {
        private ResumingState() {
        }

        @Override
        public SyncProcessState getProcessState() {
            return SyncProcessState.RESUMING;
        }
    }

    private class StartingState
    extends InternalState {
        private StartingState() {
        }

        @Override
        public SyncProcessState getProcessState() {
            return SyncProcessState.STARTING;
        }
    }

    private class PausedState
    extends InternalState {
        private PausedState() {
        }

        @Override
        public void resume() throws SyncProcessException {
            SyncProcessManagerImpl.this.resumeImpl();
        }

        @Override
        public void stop() {
            SyncProcessManagerImpl.this.stopImpl();
        }

        @Override
        public SyncProcessState getProcessState() {
            return SyncProcessState.PAUSED;
        }
    }

    private class StoppedState
    extends InternalState {
        private StoppedState() {
        }

        @Override
        public void start() throws SyncProcessException {
            SyncProcessManagerImpl.this.startImpl();
        }

        @Override
        public SyncProcessState getProcessState() {
            return SyncProcessState.STOPPED;
        }
    }

    private abstract class InternalState
    implements SyncProcess {
        private InternalState() {
        }

        @Override
        public void start() throws SyncProcessException {
        }

        @Override
        public void stop() {
        }

        @Override
        public void resume() throws SyncProcessException {
        }

        @Override
        public void pause() {
        }

        @Override
        public void restart() {
        }

        @Override
        public SyncProcessStats getProcessStats() {
            return SyncProcessManagerImpl.this.getProcessStatsImpl();
        }
    }

    private class InternalListener
    implements SyncStateChangeListener {
        private CountDownLatch latch = new CountDownLatch(1);
        private SyncProcessState state;

        public InternalListener(SyncProcessState state) {
            this.state = state;
        }

        @Override
        public void stateChanged(SyncStateChangedEvent event) {
            if (event.getProcessState() == this.state) {
                this.latch.countDown();
            }
        }

        private void waitForStateChange() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    private class InternalChangedListListener
    implements ChangedListListener {
        private InternalChangedListListener() {
        }

        @Override
        public void listChanged(final ChangedList list) {
            if (list.getListSize() > 0) {
                return;
            }
            list.removeListener(this);
            final SyncManager sm = SyncProcessManagerImpl.this.syncManager;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!this.allWorkComplete(0)) {
                        SyncProcessManagerImpl.this.sleep(2000L);
                    }
                    SyncProcessManagerImpl.this.stop();
                }

                private boolean allWorkComplete(int attempt) {
                    boolean workComplete;
                    boolean bl = workComplete = (sm == null || SyncProcessManagerImpl.this.syncManager.getFilesInTransfer().isEmpty()) && list.getListSizeIncludingReservedFiles() <= 0;
                    if (!workComplete || workComplete && attempt > 2) {
                        return workComplete;
                    }
                    SyncProcessManagerImpl.this.sleep(2000L);
                    return this.allWorkComplete(attempt + 1);
                }
            }).start();
        }
    }
}

