/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.controller;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class JQueryFileTreeController {
    @RequestMapping(value={"/ajax/jqueryFileTree"})
    public String get(@RequestParam(value="dir", required=false) String dir, Model model) throws Exception {
        ArrayList<File> children = new ArrayList<File>();
        model.addAttribute("children", children);
        if (StringUtils.isBlank(dir)) {
            File[] roots = File.listRoots();
            if (roots.length > 1) {
                children.addAll(Arrays.asList(roots));
            } else {
                this.loadChildren(roots[0], children);
            }
        } else {
            if (dir.charAt(dir.length() - 1) == '\\') {
                dir = dir.substring(0, dir.length() - 1) + "/";
            } else if (dir.charAt(dir.length() - 1) != '/') {
                dir = dir + "/";
            }
            dir = URLDecoder.decode(dir, "UTF-8");
            File directory = new File(dir);
            this.loadChildren(directory, children);
        }
        return "jqueryFileTree";
    }

    private void loadChildren(File directory, List<File> children) {
        if (directory.exists()) {
            String[] filenames = directory.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.charAt(0) != '.';
                }
            });
            Arrays.sort(filenames, String.CASE_INSENSITIVE_ORDER);
            for (String filename : filenames) {
                children.add(new File(directory, filename));
            }
        }
    }
}

