/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk.manifest.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.duracloud.ChunksManifestDocument;
import org.duracloud.ChunksManifestType;
import org.duracloud.chunk.manifest.ChunksManifest;
import org.duracloud.chunk.manifest.ChunksManifestBean;
import org.duracloud.chunk.manifest.xml.ManifestElementReader;
import org.duracloud.chunk.manifest.xml.ManifestElementWriter;
import org.duracloud.common.error.DuraCloudRuntimeException;

public class ManifestDocumentBinding {
    private ManifestDocumentBinding() {
    }

    public static ChunksManifest createManifestFrom(InputStream xml) {
        try {
            ChunksManifestDocument doc = ChunksManifestDocument.Factory.parse(xml);
            return ManifestElementReader.createManifestFrom(doc);
        }
        catch (XmlException e) {
            throw new DuraCloudRuntimeException(e);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException(e);
        }
    }

    public static String createDocumentFrom(ChunksManifestBean manifest) {
        ChunksManifestDocument doc = ChunksManifestDocument.Factory.newInstance();
        if (null != manifest) {
            ChunksManifestType manifestType = ManifestElementWriter.createChunksManifestElementFrom(manifest);
            doc.setChunksManifest(manifestType);
        }
        return ManifestDocumentBinding.docToString(doc);
    }

    private static String docToString(XmlObject doc) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            doc.save(outputStream);
        }
        catch (IOException e) {
            throw new DuraCloudRuntimeException(e);
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                throw new DuraCloudRuntimeException(e);
            }
        }
        return outputStream.toString();
    }
}

