/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.security.ProtectionDomain;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.duracloud.common.util.WaitUtil;
import org.duracloud.syncui.config.SyncUIConfig;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUIDriver {
    private static int port;
    private static String contextPath;
    private static final Logger log;

    private SyncUIDriver() {
    }

    public static void main(String[] args) throws Exception {
        CloseableHttpClient client;
        String url = "http://localhost:" + SyncUIConfig.getPort() + SyncUIConfig.getContextPath();
        if (SyncUIDriver.isAppRunning(url, client = HttpClients.createDefault())) {
            log.info("Sync Application already running, launching browser...");
            SyncUIDriver.launchBrowser(url);
        } else {
            log.info("Sync Application not yet running, launching server...");
            SyncUIDriver.launchServer(url, client);
        }
    }

    private static void launchServer(String url, CloseableHttpClient client) {
        try {
            JDialog dialog = new JDialog();
            dialog.setSize(new Dimension(400, 75));
            dialog.setModalityType(Dialog.ModalityType.MODELESS);
            dialog.setTitle("DuraCloud Sync");
            dialog.setLocationRelativeTo(null);
            JPanel panel = new JPanel();
            JLabel label = new JLabel("Loading...");
            JProgressBar progress = new JProgressBar();
            progress.setStringPainted(true);
            panel.add(label);
            panel.add(progress);
            dialog.add(panel);
            dialog.setVisible(true);
            port = SyncUIConfig.getPort();
            contextPath = SyncUIConfig.getContextPath();
            Server srv = new Server(port);
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            srv.addBean(mbContainer);
            ProtectionDomain protectionDomain = SyncUIDriver.class.getProtectionDomain();
            String warFile = protectionDomain.getCodeSource().getLocation().toExternalForm();
            log.debug("warfile: {}", (Object)warFile);
            WebAppContext context = new WebAppContext();
            context.setContextPath(contextPath);
            context.setWar(warFile);
            context.setExtractWAR(Boolean.TRUE);
            Configuration.ClassList classlist = Configuration.ClassList.setServerDefault(srv);
            classlist.addBefore("org.eclipse.jetty.webapp.JettyWebXmlConfiguration", "org.eclipse.jetty.annotations.AnnotationConfiguration");
            context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", ".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$");
            srv.setHandler(context);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SyncUIDriver.createSysTray(url, srv);
                    do {
                        if (progress.getValue() < 100) {
                            progress.setValue(progress.getValue() + 3);
                        }
                        SyncUIDriver.sleep(2000);
                    } while (!SyncUIDriver.isAppRunning(url, client));
                    progress.setValue(100);
                    label.setText("Launching browser...");
                    SyncUIDriver.launchBrowser(url);
                    dialog.setVisible(false);
                }
            }).start();
            srv.start();
            srv.join();
        }
        catch (Exception e) {
            log.error("Error launching server: " + e.getMessage(), e);
        }
    }

    private static boolean isAppRunning(String url, CloseableHttpClient client) {
        int responseCode;
        HttpGet get = new HttpGet(url);
        try {
            CloseableHttpResponse response = client.execute(get);
            responseCode = response.getStatusLine().getStatusCode();
        }
        catch (IOException e) {
            log.debug("Attempt to connect to synctool app at url " + url + " failed due to: " + e.getMessage());
            responseCode = 0;
        }
        log.debug("Response from {}: {}", (Object)url, (Object)responseCode);
        return responseCode == 200;
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void createSysTray(String url, Server srv) {
        try {
            if (SystemTray.isSupported()) {
                SystemTray tray = SystemTray.getSystemTray();
                InputStream is = SyncUIDriver.class.getClassLoader().getResourceAsStream("tray.png");
                BufferedImage image = ImageIO.read(is);
                MouseListener mouseListener = new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        log.debug("Tray Icon - Mouse clicked!");
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        log.debug("Tray Icon - Mouse entered!");
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        log.debug("Tray Icon - Mouse exited!");
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        log.debug("Tray Icon - Mouse pressed!");
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        log.debug("Tray Icon - Mouse released!");
                    }
                };
                ActionListener exitListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        log.info("Exiting...");
                        try {
                            srv.stop();
                            while (!srv.isStopped()) {
                                WaitUtil.wait(1);
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        System.exit(0);
                    }
                };
                PopupMenu popup = new PopupMenu();
                MenuItem view = new MenuItem("View Status");
                view.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        SyncUIDriver.launchBrowser(url);
                    }
                });
                popup.add(view);
                MenuItem exit = new MenuItem("Exit");
                exit.addActionListener(exitListener);
                popup.add(exit);
                TrayIcon trayIcon = new TrayIcon(image, "DuraCloud Sync Tool", popup);
                ActionListener actionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        trayIcon.displayMessage("Action Event", "An Action Event Has Been Performed!", TrayIcon.MessageType.INFO);
                    }
                };
                trayIcon.setImageAutoSize(true);
                trayIcon.addActionListener(actionListener);
                trayIcon.addMouseListener(mouseListener);
                try {
                    tray.add(trayIcon);
                }
                catch (AWTException e) {
                    log.error("TrayIcon could not be added.");
                }
            } else {
                log.warn("System Tray is not supported.");
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    private static void launchBrowser(String url) {
        if (!Desktop.isDesktopSupported()) {
            log.warn("Desktop is not supported. Unable to open");
        } else {
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                log.warn("Desktop doesn't support the browse action.");
            } else {
                try {
                    URI uri = new URI(url);
                    desktop.browse(uri);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    static /* synthetic */ void access$000(String x0, Server x1) {
        SyncUIDriver.createSysTray(x0, x1);
    }

    static /* synthetic */ void access$100(int x0) {
        SyncUIDriver.sleep(x0);
    }

    static /* synthetic */ boolean access$200(String x0, CloseableHttpClient x1) {
        return SyncUIDriver.isAppRunning(x0, x1);
    }

    static /* synthetic */ void access$300(String x0) {
        SyncUIDriver.launchBrowser(x0);
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }

    static {
        log = LoggerFactory.getLogger(SyncUIDriver.class);
    }
}

