/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.controller;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class JQueryFileTreeController {
    @RequestMapping(value={"/ajax/jqueryFileTree"})
    public String get(@RequestParam(value="dir", required=false) String dir, Model model) throws Exception {
        ArrayList<File> children = new ArrayList<File>();
        model.addAttribute("children", children);
        if (StringUtils.isBlank((String)dir)) {
            File[] roots = File.listRoots();
            if (roots.length > 1) {
                children.addAll(Arrays.asList(roots));
            } else {
                this.loadChildren(roots[0], children);
            }
        } else {
            if (((String)dir).charAt(((String)dir).length() - 1) == '\\') {
                dir = ((String)dir).substring(0, ((String)dir).length() - 1) + "/";
            } else if (((String)dir).charAt(((String)dir).length() - 1) != '/') {
                dir = (String)dir + "/";
            }
            dir = URLDecoder.decode((String)dir, "UTF-8");
            File directory = new File((String)dir);
            this.loadChildren(directory, children);
        }
        return "jqueryFileTree";
    }

    private void loadChildren(File directory, List<File> children) {
        if (directory.exists()) {
            String[] filenames = directory.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
            Arrays.sort(filenames, String.CASE_INSENSITIVE_ORDER);
            for (String filename : filenames) {
                children.add(new File(directory, filename));
            }
        }
    }
}

