/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.duracloud.syncui.config.SyncUIConfig;
import org.duracloud.syncui.domain.SyncProcessState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuntimeStateMemento {
    private static Logger log = LoggerFactory.getLogger(RuntimeStateMemento.class);
    private SyncProcessState syncProcessState;

    public SyncProcessState getSyncProcessState() {
        return this.syncProcessState;
    }

    public void setSyncProcessState(SyncProcessState syncProcessState) {
        this.syncProcessState = syncProcessState;
    }

    private static File getStateFile() {
        File workDir = SyncUIConfig.getWorkDir();
        File stateFile = new File(workDir, ".runtime-state.xml");
        return stateFile;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static RuntimeStateMemento get() {
        File stateFile = RuntimeStateMemento.getStateFile();
        if (stateFile.exists()) {
            RuntimeStateMemento runtimeStateMemento;
            FileInputStream is = new FileInputStream(stateFile);
            try {
                log.debug("retrieving state from {}", (Object)stateFile.getAbsolutePath());
                XStream xstream = new XStream();
                runtimeStateMemento = (RuntimeStateMemento)xstream.fromXML((InputStream)is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to persist internal state: should never happen", (Throwable)e);
                    System.exit(1);
                    return null;
                }
            }
            ((InputStream)is).close();
            return runtimeStateMemento;
        }
        log.debug("not state file found at {}: creating new memento", (Object)stateFile.getAbsolutePath());
        return new RuntimeStateMemento();
    }

    public static void persist(RuntimeStateMemento state) {
        File stateFile = RuntimeStateMemento.getStateFile();
        try (FileOutputStream os = new FileOutputStream(stateFile);){
            new XStream().toXML((Object)state, (OutputStream)os);
            log.debug("successfully saved {} to {}", (Object)state, (Object)stateFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("Failed to persist internal state: should never happen", (Throwable)e);
            System.exit(1);
        }
    }
}

