/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.duracloud.sync.config.SyncToolConfig;
import org.duracloud.syncui.config.SyncUIConfig;
import org.duracloud.syncui.domain.DirectoryConfig;
import org.duracloud.syncui.domain.DirectoryConfigs;
import org.duracloud.syncui.domain.DuracloudConfiguration;
import org.duracloud.syncui.service.RunMode;
import org.duracloud.syncui.service.SyncConfigurationManager;
import org.duracloud.syncui.service.SyncToolConfigSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="syncConfigurationManager")
public class SyncConfigurationManagerImpl
implements SyncConfigurationManager {
    private static Logger log = LoggerFactory.getLogger(SyncConfigurationManagerImpl.class);
    private SyncToolConfig syncToolConfig;
    private String configXmlPath;

    public SyncConfigurationManagerImpl() {
        String configPath = SyncUIConfig.getConfigPath();
        this.setConfigXmlPath(configPath);
        this.initializeSyncToolConfig();
    }

    private void persistSyncToolConfig() throws RuntimeException {
        try {
            SyncToolConfigSerializer.serialize((SyncToolConfig)this.syncToolConfig, (String)this.getSyncToolConfigXmlPath());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeSyncToolConfig() {
        try {
            this.syncToolConfig = SyncToolConfigSerializer.deserialize((String)this.getSyncToolConfigXmlPath());
        }
        catch (IOException ex) {
            log.warn("unable to deserialize sync config : " + ex.getMessage());
            log.info("creating new config...");
            this.syncToolConfig = new SyncToolConfig();
            this.initializeDefaultValues();
        }
    }

    private void initializeDefaultValues() {
        this.syncToolConfig.setContext("durastore");
        this.syncToolConfig.setExitOnCompletion(false);
        this.syncToolConfig.setSyncDeletes(false);
        ArrayList dirs = new ArrayList();
        this.syncToolConfig.setContentDirs(dirs);
        this.syncToolConfig.setMaxFileSize(1000000000L);
    }

    private String getSyncToolConfigXmlPath() {
        return this.configXmlPath;
    }

    public void persistDuracloudConfiguration(String username, String password, String host, String port, String spaceId) {
        this.syncToolConfig.setUsername(username);
        this.syncToolConfig.setPassword(password);
        this.syncToolConfig.setHost(host);
        this.syncToolConfig.setPort(Integer.parseInt(port));
        this.syncToolConfig.setSpaceId(spaceId);
        this.persistSyncToolConfig();
    }

    public DuracloudConfiguration retrieveDuracloudConfiguration() {
        SyncToolConfig s = this.syncToolConfig;
        return new DuracloudConfiguration(s.getUsername(), s.getPassword(), s.getHost(), s.getPort(), s.getSpaceId());
    }

    public DirectoryConfigs retrieveDirectoryConfigs() {
        DirectoryConfigs c = new DirectoryConfigs();
        List dirs = this.syncToolConfig.getContentDirs();
        for (File f : dirs) {
            c.add((Object)new DirectoryConfig(f.getAbsolutePath()));
        }
        return c;
    }

    public void persistDirectoryConfigs(DirectoryConfigs configs) {
        LinkedList<File> dirs = new LinkedList<File>();
        for (DirectoryConfig f : configs) {
            dirs.add(new File(f.getDirectoryPath()));
        }
        this.syncToolConfig.setContentDirs(dirs);
        this.persistSyncToolConfig();
    }

    public boolean isConfigurationComplete() {
        SyncToolConfig c = this.syncToolConfig;
        if (c == null) {
            return false;
        }
        return !StringUtils.isBlank((String)c.getUsername()) && !StringUtils.isBlank((String)c.getUsername()) && !StringUtils.isBlank((String)c.getPassword()) && !StringUtils.isBlank((String)c.getHost()) && !StringUtils.isBlank((String)c.getSpaceId());
    }

    public void setConfigXmlPath(String configXml) {
        if (this.configXmlPath != configXml) {
            this.configXmlPath = configXml;
            this.initializeSyncToolConfig();
        }
        log.info("xml config path set to {}", (Object)this.configXmlPath);
    }

    public void persist() {
        this.persistSyncToolConfig();
    }

    public File getWorkDirectory() {
        return SyncUIConfig.getWorkDir();
    }

    public void purgeWorkDirectory() {
        try {
            FileUtils.cleanDirectory((File)SyncUIConfig.getWorkDir());
        }
        catch (IOException e) {
            log.error("Unable to clean work directory due to: " + e.getMessage());
        }
    }

    public boolean isSyncDeletes() {
        return this.syncToolConfig.syncDeletes();
    }

    public void setSyncDeletes(boolean flag) {
        if (flag && this.syncToolConfig.isRenameUpdates()) {
            return;
        }
        this.syncToolConfig.setSyncDeletes(flag);
        this.persistSyncToolConfig();
    }

    public String getUpdateSuffix() {
        return this.syncToolConfig.getUpdateSuffix();
    }

    public void setSyncUpdates(boolean b) {
        this.syncToolConfig.setSyncUpdates(b);
        this.persistSyncToolConfig();
    }

    public boolean isSyncUpdates() {
        return this.syncToolConfig.isSyncUpdates();
    }

    public void setRenameUpdates(boolean b) {
        if (b && this.syncToolConfig.syncDeletes()) {
            return;
        }
        this.syncToolConfig.setRenameUpdates(b);
        this.persistSyncToolConfig();
    }

    public boolean isRenameUpdates() {
        return this.syncToolConfig.isRenameUpdates();
    }

    public String getPrefix() {
        return this.syncToolConfig.getPrefix();
    }

    public void setPrefix(String prefix) {
        this.syncToolConfig.setPrefix(prefix);
        this.persistSyncToolConfig();
    }

    public int getThreadCount() {
        return this.syncToolConfig.getNumThreads();
    }

    public void setThreadCount(int threadCount) {
        this.syncToolConfig.setNumThreads(threadCount);
        this.persistSyncToolConfig();
    }

    public void setJumpStart(boolean jumpStart) {
        if (jumpStart && !this.syncToolConfig.isSyncUpdates() || jumpStart && this.syncToolConfig.isRenameUpdates()) {
            return;
        }
        this.syncToolConfig.setJumpStart(jumpStart);
        this.persistSyncToolConfig();
    }

    public boolean isJumpStart() {
        return this.syncToolConfig.isJumpStart();
    }

    public RunMode getMode() {
        return this.syncToolConfig.exitOnCompletion() ? RunMode.SINGLE_PASS : RunMode.CONTINUOUS;
    }

    public void setMode(RunMode mode) {
        RunMode newValue;
        RunMode oldValue = this.getMode();
        if (oldValue != (newValue = mode)) {
            this.syncToolConfig.setExitOnCompletion(newValue.equals((Object)RunMode.SINGLE_PASS));
            this.persistSyncToolConfig();
        }
    }

    public void setMaxFileSizeInBytes(long maxFileSize) {
        int gigs = (int)(maxFileSize / 1000000000L);
        if (maxFileSize % 1000000000L != 0L || gigs < 1 || gigs > 5) {
            throw new RuntimeException("Max file size must be divisible by 1000 and between 1 and 5 GBs inclusive");
        }
        long oldValue = this.getMaxFileSizeInBytes();
        if (oldValue != maxFileSize) {
            this.syncToolConfig.setMaxFileSize(maxFileSize);
            this.persistSyncToolConfig();
        }
    }

    public long getMaxFileSizeInBytes() {
        return this.syncToolConfig.getMaxFileSize();
    }
}

