/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.domain;

import java.io.Serializable;
import javax.validation.GroupSequence;
import javax.validation.constraints.NotNull;
import org.duracloud.syncui.domain.DuracloudConfiguration;
import org.duracloud.syncui.domain.DuracloudCredentialsCoherenceChecker;
import org.duracloud.syncui.domain.DuracloudCredentialsForm;
import org.springframework.stereotype.Component;

@Component(value="duracloudCredentialsForm")
@GroupSequence(value={DuracloudCredentialsForm.class, HighLevelCoherence.class})
@DuracloudCredentialsCoherenceChecker(groups={HighLevelCoherence.class})
public class DuracloudCredentialsForm
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull(message="*Required field.")
    private String username;
    @NotNull(message="*Required field.")
    private String password;
    @NotNull(message="*Required field.")
    private String host;
    @NotNull
    private String port;

    public DuracloudCredentialsForm() {
        this.port = DuracloudConfiguration.DEFAULT_PORT;
    }

    public DuracloudCredentialsForm(DuracloudConfiguration config) {
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.host = config.getHost();
        this.port = "" + config.getPort();
    }

    public boolean isDefaultPort() {
        return DuracloudConfiguration.DEFAULT_PORT.equals(this.port);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

