/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.syncui.service;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.duracloud.syncoptimize.SyncOptimizeDriver;
import org.duracloud.syncoptimize.status.SyncTestEvent;
import org.duracloud.syncoptimize.status.SyncTestStatus;
import org.duracloud.syncui.controller.SyncOptimizeManagerResultCallBack;
import org.duracloud.syncui.service.SyncConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="syncOptimizeManager")
public class SyncOptimizeManager {
    private SyncOptimizeDriver syncOptimizeDriver;
    private SyncConfigurationManager syncConfigurationManager;
    private Date startTime = null;
    private String status = null;
    private boolean running = false;
    private boolean failed = false;
    private static final Logger log = LoggerFactory.getLogger(SyncOptimizeManager.class);

    public SyncOptimizeManager(SyncConfigurationManager syncConfigurationManager, SyncOptimizeDriver syncOptimizeDriver) {
        this.syncConfigurationManager = syncConfigurationManager;
        this.syncOptimizeDriver = syncOptimizeDriver;
        this.reset();
    }

    @Autowired
    public SyncOptimizeManager(SyncConfigurationManager syncConfigurationManager) {
        this(syncConfigurationManager, new SyncOptimizeDriver(false));
    }

    private void reset() {
        this.status = "";
        this.failed = false;
        this.startTime = new Date();
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getStatus() {
        if (this.running) {
            this.updateRunningStatus();
        }
        return this.status;
    }

    public boolean isFailed() {
        return this.failed;
    }

    protected void updateRunningStatus() {
        SyncTestStatus syncTestStatus = this.syncOptimizeDriver.getSyncTestStatus();
        List events = syncTestStatus.getSyncEvents();
        if (events.size() > 0) {
            Collections.sort(events, new /* Unavailable Anonymous Inner Class!! */);
            SyncTestEvent best = (SyncTestEvent)events.get(0);
            this.status = MessageFormat.format("Transfer rate optimization underway. Current test started at {0}. {1} tests so far run. Best run so far: {2}", this.startTime, events.size(), best.toString());
        } else {
            this.status = this.startTime + ": Started, but no tests have completed yet.";
        }
    }

    public void start(SyncOptimizeManagerResultCallBack callback) {
        if (this.isRunning()) {
            throw new IllegalStateException("The start() method cannot be called when the sync optimize process is running.");
        }
        this.running = true;
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }
}

