/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.unittestdb;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.duracloud.common.error.DuraCloudRuntimeException;
import org.duracloud.common.model.Credential;
import org.duracloud.common.util.DatabaseUtil;
import org.duracloud.common.util.TableSpec;
import org.duracloud.unittestdb.PasswordRepositoryDBImpl;
import org.duracloud.unittestdb.domain.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitTestDatabaseUtil
extends DatabaseUtil {
    protected static final Logger log = LoggerFactory.getLogger(UnitTestDatabaseUtil.class);
    private final List<TableSpec> tableSpecs = Arrays.asList(PasswordRepositoryDBImpl.getTableSpec());
    PasswordRepositoryDBImpl repo;

    public UnitTestDatabaseUtil() throws Exception {
        this(UnitTestDatabaseUtil.getDatabaseCredential(), UnitTestDatabaseUtil.getDatabaseHome(), UnitTestDatabaseUtil.getBootPassword());
    }

    public UnitTestDatabaseUtil(Credential cred, String baseDir, String bootPassword) throws Exception {
        super(cred, baseDir, bootPassword);
        if (!UnitTestDatabaseUtil.isValid(baseDir, bootPassword)) {
            log.error("unit.database.home='" + baseDir + "'");
            log.error("unit.database.password='" + bootPassword + "'");
            throw new Exception(UnitTestDatabaseUtil.usage());
        }
        this.repo = this.createRepo();
    }

    private PasswordRepositoryDBImpl createRepo() {
        log.debug("creating Password DB");
        PasswordRepositoryDBImpl repo = new PasswordRepositoryDBImpl();
        repo.setDataSource(this.getDataSource());
        return repo;
    }

    @Override
    protected List<TableSpec> getTableSpecs() {
        return this.tableSpecs;
    }

    public void createNewDB() throws Exception {
        this.initializeDB();
    }

    public void connectToExistingDB() throws Exception {
        this.ensureDatabaseExists();
        this.ensureTablesExist();
    }

    public void insertCredentialForResource(ResourceType type, Credential cred) {
        this.repo.insertPassword(type, cred.getUsername(), cred.getPassword());
    }

    public Credential findCredentialForResource(ResourceType resource) throws Exception {
        return this.repo.findCredentialByResourceType(resource);
    }

    public static boolean isValid(String ... texts) {
        boolean valid = true;
        for (String text : texts) {
            if (!StringUtils.isBlank(text)) continue;
            valid = false;
        }
        return valid;
    }

    private static Credential getDatabaseCredential() {
        return new Credential("duracloud", "duracloud");
    }

    private static String getBootPassword() {
        String password = System.getProperty("unit.database.password");
        if (null == password) {
            throw new DuraCloudRuntimeException(UnitTestDatabaseUtil.usage());
        }
        return password;
    }

    private static String getDatabaseHome() {
        String home = System.getProperty("unit.database.home");
        if (null == home) {
            throw new DuraCloudRuntimeException(UnitTestDatabaseUtil.usage());
        }
        return home;
    }

    public static String usage() {
        StringBuilder sb = new StringBuilder("\n----------------------------\n");
        sb.append("Usage:");
        sb.append("\n\tUnitTestDatabaseUtil ");
        sb.append("-Dunit.database.password=<boot-password> ");
        sb.append("-Dunit.database.home=<location-of-database>");
        sb.append("\n\n\tWhere <boot-password> is the password to ");
        sb.append("boot the encrypted database.");
        sb.append("\n\n\tAnd <location-of-database> is the full path to ");
        sb.append("\n\tthe desired location of the populated database.");
        sb.append("\n\n\tNOTE: When running storage-provider unit tests ");
        sb.append("in maven,");
        sb.append("\n\tthe maven settings.xml should hold the ");
        sb.append("unit.database.password and unit.database.home.");
        sb.append("\n\tSee notes in resources/install-notes.txt");
        sb.append("\n----------------------------\n");
        return sb.toString();
    }
}

