/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.unittestdb.domain;

import java.util.ArrayList;
import java.util.List;
import org.duracloud.common.model.DuraCloudUserType;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.unittestdb.error.UnknownResourceTypeException;

public class ResourceType {
    private String id;

    private ResourceType(String id) {
        this.id = id;
    }

    public static ResourceType fromString(String type) {
        for (StorageProviderType storageProviderType : StorageProviderType.values()) {
            if (!storageProviderType.toString().equalsIgnoreCase(type) && !storageProviderType.name().equalsIgnoreCase(type)) continue;
            return new ResourceType(type);
        }
        for (StorageProviderType storageProviderType : DuraCloudUserType.values()) {
            if (!storageProviderType.toString().equalsIgnoreCase(type) && !storageProviderType.name().equalsIgnoreCase(type)) continue;
            return new ResourceType(type);
        }
        throw new UnknownResourceTypeException(type);
    }

    public static ResourceType fromStorageProviderType(StorageProviderType type) {
        return new ResourceType(type.toString());
    }

    public static ResourceType fromDuraCloudUserType(DuraCloudUserType type) {
        return new ResourceType(type.toString());
    }

    public static List<ResourceType> values() {
        ArrayList<ResourceType> types = new ArrayList<ResourceType>();
        for (StorageProviderType storageProviderType : StorageProviderType.values()) {
            types.add(new ResourceType(storageProviderType.toString()));
        }
        for (StorageProviderType storageProviderType : DuraCloudUserType.values()) {
            types.add(new ResourceType(storageProviderType.toString()));
        }
        return types;
    }

    public String toString() {
        return this.id;
    }
}

