/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.TaskOverride;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String taskDefinition;
    private TaskOverride overrides;
    private ListWithAutoConstructFlag<String> containerInstances;
    private String startedBy;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public StartTaskRequest withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public StartTaskRequest withTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
        return this;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public StartTaskRequest withOverrides(TaskOverride overrides) {
        this.overrides = overrides;
        return this;
    }

    public List<String> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new ListWithAutoConstructFlag();
            this.containerInstances.setAutoConstruct(true);
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        ListWithAutoConstructFlag containerInstancesCopy = new ListWithAutoConstructFlag(containerInstances.size());
        containerInstancesCopy.addAll(containerInstances);
        this.containerInstances = containerInstancesCopy;
    }

    public StartTaskRequest withContainerInstances(String ... containerInstances) {
        if (this.getContainerInstances() == null) {
            this.setContainerInstances(new ArrayList<String>(containerInstances.length));
        }
        for (String value : containerInstances) {
            this.getContainerInstances().add(value);
        }
        return this;
    }

    public StartTaskRequest withContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
        } else {
            ListWithAutoConstructFlag containerInstancesCopy = new ListWithAutoConstructFlag(containerInstances.size());
            containerInstancesCopy.addAll(containerInstances);
            this.containerInstances = containerInstancesCopy;
        }
        return this;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public StartTaskRequest withStartedBy(String startedBy) {
        this.startedBy = startedBy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: " + this.getTaskDefinition() + ",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: " + this.getOverrides() + ",");
        }
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: " + this.getContainerInstances() + ",");
        }
        if (this.getStartedBy() != null) {
            sb.append("StartedBy: " + this.getStartedBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        hashCode = 31 * hashCode + (this.getStartedBy() == null ? 0 : this.getStartedBy().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskRequest)) {
            return false;
        }
        StartTaskRequest other = (StartTaskRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        if (other.getContainerInstances() != null && !other.getContainerInstances().equals(this.getContainerInstances())) {
            return false;
        }
        if (other.getStartedBy() == null ^ this.getStartedBy() == null) {
            return false;
        }
        return other.getStartedBy() == null || other.getStartedBy().equals(this.getStartedBy());
    }

    @Override
    public StartTaskRequest clone() {
        return (StartTaskRequest)super.clone();
    }
}

