/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.unittestdb.util;

import org.duracloud.common.model.Credential;
import org.duracloud.common.model.DuraCloudUserType;
import org.duracloud.common.util.EncryptionUtil;
import org.duracloud.common.web.RestHttpHelper;
import org.duracloud.storage.domain.StorageProviderType;
import org.duracloud.unittestdb.UnitTestDatabaseUtil;
import org.duracloud.unittestdb.domain.ResourceType;

public class StorageAccountTestUtil {
    private Credential rootCredential;

    public RestHttpHelper.HttpResponse initializeDurastore(String host, String port, String context) throws Exception {
        String baseURL = "http://" + host + ":" + port + "/" + context;
        String storesURL = baseURL + "/stores";
        String xml = this.buildTestAccountXml();
        RestHttpHelper restHelper = new RestHttpHelper(this.getRootCredential());
        return restHelper.post(storesURL, xml, null);
    }

    private String buildTestAccountXml() throws Exception {
        StringBuilder xml = new StringBuilder();
        xml.append("<storageProviderAccounts>");
        UnitTestDatabaseUtil dbUtil = new UnitTestDatabaseUtil();
        int acctId = 0;
        for (StorageProviderType type : StorageProviderType.values()) {
            Credential cred = null;
            try {
                cred = dbUtil.findCredentialForResource(ResourceType.fromStorageProviderType(type));
            }
            catch (Exception e) {
                if (!type.equals((Object)StorageProviderType.TEST_RETRY) && !type.equals((Object)StorageProviderType.TEST_VERIFY_CREATE) && !type.equals((Object)StorageProviderType.TEST_VERIFY_DELETE)) continue;
                cred = new Credential("", "");
            }
            if (cred == null) continue;
            ++acctId;
            EncryptionUtil encryptUtil = new EncryptionUtil();
            String encUsername = encryptUtil.encrypt(cred.getUsername());
            String encPassword = encryptUtil.encrypt(cred.getPassword());
            xml.append("<storageAcct ownerId='0'");
            if (type.equals((Object)StorageProviderType.AMAZON_S3)) {
                xml.append(" isPrimary='1'");
            }
            xml.append(">");
            xml.append("<id>" + acctId + "</id>");
            xml.append("<storageProviderType>");
            xml.append(type.name());
            xml.append("</storageProviderType>");
            xml.append("<storageProviderCredential>");
            xml.append("<username>" + encUsername + "</username>");
            xml.append("<password>" + encPassword + "</password>");
            xml.append("</storageProviderCredential>");
            xml.append("</storageAcct>");
        }
        xml.append("</storageProviderAccounts>");
        return xml.toString();
    }

    public Credential getRootCredential() throws Exception {
        if (null == this.rootCredential) {
            UnitTestDatabaseUtil dbUtil = new UnitTestDatabaseUtil();
            ResourceType rootUser = ResourceType.fromDuraCloudUserType(DuraCloudUserType.ROOT);
            this.rootCredential = dbUtil.findCredentialForResource(rootUser);
        }
        return this.rootCredential;
    }
}

