/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.HealthCheckConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateHealthCheckRequestMarshaller
implements Marshaller<Request<CreateHealthCheckRequest>, CreateHealthCheckRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<CreateHealthCheckRequest> marshall(CreateHealthCheckRequest createHealthCheckRequest) {
        HealthCheckConfig healthCheckConfigHealthCheckConfig;
        if (createHealthCheckRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateHealthCheckRequest> request = new DefaultRequest<CreateHealthCheckRequest>(createHealthCheckRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
        xmlWriter.startElement("CreateHealthCheckRequest");
        if (createHealthCheckRequest.getCallerReference() != null) {
            xmlWriter.startElement("CallerReference").value(createHealthCheckRequest.getCallerReference()).endElement();
        }
        if (createHealthCheckRequest != null && (healthCheckConfigHealthCheckConfig = createHealthCheckRequest.getHealthCheckConfig()) != null) {
            List<String> healthCheckConfigHealthCheckConfigchildHealthChecksList;
            xmlWriter.startElement("HealthCheckConfig");
            if (healthCheckConfigHealthCheckConfig.getIPAddress() != null) {
                xmlWriter.startElement("IPAddress").value(healthCheckConfigHealthCheckConfig.getIPAddress()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getPort() != null) {
                xmlWriter.startElement("Port").value(healthCheckConfigHealthCheckConfig.getPort()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getType() != null) {
                xmlWriter.startElement("Type").value(healthCheckConfigHealthCheckConfig.getType()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getResourcePath() != null) {
                xmlWriter.startElement("ResourcePath").value(healthCheckConfigHealthCheckConfig.getResourcePath()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getFullyQualifiedDomainName() != null) {
                xmlWriter.startElement("FullyQualifiedDomainName").value(healthCheckConfigHealthCheckConfig.getFullyQualifiedDomainName()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getSearchString() != null) {
                xmlWriter.startElement("SearchString").value(healthCheckConfigHealthCheckConfig.getSearchString()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getRequestInterval() != null) {
                xmlWriter.startElement("RequestInterval").value(healthCheckConfigHealthCheckConfig.getRequestInterval()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getFailureThreshold() != null) {
                xmlWriter.startElement("FailureThreshold").value(healthCheckConfigHealthCheckConfig.getFailureThreshold()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.isMeasureLatency() != null) {
                xmlWriter.startElement("MeasureLatency").value(healthCheckConfigHealthCheckConfig.isMeasureLatency()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.isInverted() != null) {
                xmlWriter.startElement("Inverted").value(healthCheckConfigHealthCheckConfig.isInverted()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig.getHealthThreshold() != null) {
                xmlWriter.startElement("HealthThreshold").value(healthCheckConfigHealthCheckConfig.getHealthThreshold()).endElement();
            }
            if (healthCheckConfigHealthCheckConfig != null && (healthCheckConfigHealthCheckConfigchildHealthChecksList = healthCheckConfigHealthCheckConfig.getChildHealthChecks()) != null && healthCheckConfigHealthCheckConfigchildHealthChecksList.size() > 0) {
                int healthCheckConfigHealthCheckConfigchildHealthChecksListIndex = 1;
                xmlWriter.startElement("ChildHealthChecks");
                for (String healthCheckConfigHealthCheckConfigchildHealthChecksListValue : healthCheckConfigHealthCheckConfigchildHealthChecksList) {
                    xmlWriter.startElement("ChildHealthCheck");
                    xmlWriter.value(healthCheckConfigHealthCheckConfigchildHealthChecksListValue);
                    xmlWriter.endElement();
                    ++healthCheckConfigHealthCheckConfigchildHealthChecksListIndex;
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    static {
        String path = "/2013-04-01/healthcheck";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

