/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.unittestdb;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.duracloud.common.model.Credential;
import org.duracloud.common.util.TableSpec;
import org.duracloud.unittestdb.domain.ResourceType;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public class PasswordRepositoryDBImpl
extends SimpleJdbcDaoSupport {
    private static final String tablename = "passwords";
    private static final String idCol = "id";
    private static final String resourceTypeCol = "providerType";
    private static final String usernameCol = "username";
    private static final String passwordCol = "password";
    private final String PASSWORD_INSERT = "INSERT INTO passwords (providerType, username, password) VALUES (:providerType, :username, :password)";
    private final String PASSWORD_SELECT = "SELECT password FROM passwords";
    private final String CREDENTIAL_SELECT_BY_RESOURCE_TYPE = "SELECT username, password FROM passwords WHERE providerType = ? ";
    private final String PASSWORD_SELECT_BY_RESOURCE_TYPE_AND_USERNAME = "SELECT password FROM passwords WHERE providerType = ? AND username = ? ";
    private static final String ddl = "CREATE TABLE passwords (id INT GENERATED ALWAYS AS IDENTITY,providerType VARCHAR(32) NOT NULL,username VARCHAR(64) NOT NULL,password VARCHAR(128) NOT NULL)";

    public void insertPassword(ResourceType resource, String username, String password) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(resourceTypeCol, resource.toString());
        params.put(usernameCol, username);
        params.put(passwordCol, password);
        this.getSimpleJdbcTemplate().update("INSERT INTO passwords (providerType, username, password) VALUES (:providerType, :username, :password)", params);
    }

    public Credential findCredentialByResourceType(ResourceType resourceType) throws Exception {
        List<Credential> credentials = this.getSimpleJdbcTemplate().query("SELECT username, password FROM passwords WHERE providerType = ? ", new ParameterizedRowMapper<Credential>(){

            @Override
            public Credential mapRow(ResultSet rs, int rowNum) throws SQLException {
                String username = rs.getString(PasswordRepositoryDBImpl.usernameCol);
                String password = rs.getString(PasswordRepositoryDBImpl.passwordCol);
                return new Credential(username, password);
            }
        }, new Object[]{resourceType.toString()});
        if (credentials.size() == 0) {
            throw new Exception("Table is empty: 'passwords'");
        }
        if (credentials.size() != 1) {
            throw new Exception("passwords contains more than one entry for resourceType: " + resourceType.toString());
        }
        return credentials.get(0);
    }

    public String findPasswordByResourceTypeAndUsername(ResourceType resourceType, String username) throws Exception {
        List<String> passwords = this.getSimpleJdbcTemplate().query("SELECT password FROM passwords WHERE providerType = ? AND username = ? ", new ParameterizedRowMapper<String>(){

            @Override
            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(PasswordRepositoryDBImpl.passwordCol);
            }
        }, new Object[]{resourceType.toString(), username});
        if (passwords.size() == 0) {
            throw new Exception("Table is empty: 'passwords'");
        }
        if (passwords.size() != 1) {
            throw new Exception("passwords contains more than one entry for resourceType and username : [" + resourceType.toString() + "|" + username + "]");
        }
        return passwords.get(0);
    }

    public static TableSpec getTableSpec() {
        TableSpec ts = new TableSpec();
        ts.setTableName(tablename);
        ts.setPrimaryKey(idCol);
        ts.setDdl(ddl);
        return ts;
    }
}

