/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.unittestdb;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.duracloud.common.model.Credential;
import org.duracloud.unittestdb.UnitTestDatabaseUtil;
import org.duracloud.unittestdb.domain.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitTestDatabaseLoaderCLI {
    protected static final Logger log = LoggerFactory.getLogger(UnitTestDatabaseUtil.class);
    private final UnitTestDatabaseUtil dbUtil = new UnitTestDatabaseUtil();

    private void begin() throws Exception {
        if (this.inputCreateNewDB()) {
            this.dbUtil.createNewDB();
        } else {
            this.dbUtil.connectToExistingDB();
        }
        this.inputPasswords();
    }

    private boolean inputCreateNewDB() {
        System.out.println("[A]ppend to existing db or [C]reate new db? a|c:");
        String cmd = this.readLine().trim();
        while (!cmd.equalsIgnoreCase("a") && !cmd.equalsIgnoreCase("c")) {
            System.out.println("Invalid entry: '" + cmd + "', try again: 'a' or 'c'");
            cmd = this.readLine().trim();
        }
        return cmd.equals("c");
    }

    private void inputPasswords() {
        do {
            ResourceType type = this.inputResourceType();
            String username = this.inputUsername();
            String password = this.inputPassword();
            if (!UnitTestDatabaseLoaderCLI.isValid(username, password)) continue;
            Credential cred = new Credential(username, password);
            this.dbUtil.insertCredentialForResource(type, cred);
        } while (!this.inputFinished());
    }

    private ResourceType inputResourceType() {
        StringBuilder sb = new StringBuilder("Enter resource type from [");
        for (ResourceType type : ResourceType.values()) {
            sb.append(type + ", ");
        }
        sb.replace(sb.length() - 2, sb.length(), "]");
        System.out.println(sb.toString());
        String type = this.readLine().trim();
        while (this.unknownResourceType(type)) {
            System.out.println("Invalid entry: '" + type + "', try again.");
            type = this.readLine().trim();
        }
        return ResourceType.fromString(type);
    }

    private boolean unknownResourceType(String type) {
        try {
            ResourceType.fromString(type);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private String inputUsername() {
        System.out.println("Enter username: ");
        return this.readLine().trim();
    }

    private String inputPassword() {
        System.out.println("Enter password: ");
        return this.readLine().trim();
    }

    private boolean inputFinished() {
        System.out.println("Continue? y|n: ");
        String value = this.readLine().trim();
        return !UnitTestDatabaseLoaderCLI.isValid(value) || value.equalsIgnoreCase("n");
    }

    private String readLine() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            return reader.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException("Error: Unable to read from STDIN");
        }
    }

    private static boolean isValid(String ... texts) {
        return UnitTestDatabaseUtil.isValid(texts);
    }

    public static void main(String[] args) {
        try {
            UnitTestDatabaseLoaderCLI cli = new UnitTestDatabaseLoaderCLI();
            cli.begin();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

