/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import org.apache.derby.iapi.db.OptimizerTrace;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.impl.sql.compile.DefaultOptTrace;
import org.apache.derby.impl.sql.compile.XMLOptTrace;

public class OptimizerTracer
implements OptionalTool {
    @Override
    public void loadTool(String ... stringArray) throws SQLException {
        OptTrace optTrace;
        if (stringArray == null || stringArray.length == 0) {
            optTrace = new DefaultOptTrace();
        } else if ("xml".equals(stringArray[0])) {
            try {
                optTrace = new XMLOptTrace();
            }
            catch (Throwable throwable) {
                throw this.wrap(throwable);
            }
        } else if ("custom".equals(stringArray[0])) {
            if (stringArray.length != 2) {
                throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
            }
            String string = stringArray[1];
            try {
                ClassFactoryContext classFactoryContext = (ClassFactoryContext)ContextService.getContext("ClassFactoryContext");
                ClassFactory classFactory = classFactoryContext.getClassFactory();
                optTrace = (OptTrace)classFactory.loadApplicationClass(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw this.cantInstantiate(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw this.cantInstantiate(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw this.cantInstantiate(string);
            }
            catch (Throwable throwable) {
                throw this.wrap(throwable);
            }
        } else {
            throw this.wrap(MessageService.getTextMessage("X0Y89.S", new Object[0]));
        }
        OptimizerTrace.setOptimizerTracer(optTrace);
    }

    private SQLException cantInstantiate(String string) {
        return this.wrap(MessageService.getTextMessage("X0Y90.S", string));
    }

    @Override
    public void unloadTool(final String ... stringArray) throws SQLException {
        try {
            PrintWriter printWriter;
            OptTrace optTrace = OptimizerTrace.getOptimizerTracer();
            boolean bl = false;
            if (stringArray != null && stringArray.length > 0) {
                printWriter = AccessController.doPrivileged(new PrivilegedAction<PrintWriter>(){

                    @Override
                    public PrintWriter run() {
                        try {
                            return new PrintWriter(stringArray[0]);
                        }
                        catch (IOException iOException) {
                            throw new IllegalArgumentException(iOException.getMessage(), iOException);
                        }
                    }
                });
                bl = true;
            } else {
                printWriter = new PrintWriter(System.out);
            }
            if (optTrace != null) {
                optTrace.printToWriter(printWriter);
                printWriter.flush();
            }
            if (bl) {
                printWriter.close();
            }
        }
        catch (Exception exception) {
            throw this.wrap(exception);
        }
        finally {
            OptimizerTrace.setOptimizerTracer(null);
        }
    }

    private SQLException wrap(Throwable throwable) {
        return new SQLException(throwable.getMessage(), throwable);
    }

    private SQLException wrap(String string) {
        String string2 = "XJ001.U".substring(0, 5);
        return new SQLException(string, string2);
    }
}

