/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload;

import java.util.ArrayList;
import java.util.List;

public class UploadStatus {
    private boolean complete;
    private int totalFiles;
    private int completeFiles;
    private List<FileInTransfer> filesInTransfer;

    public UploadStatus(boolean complete, int totalFiles, int completeFiles) {
        this.complete = complete;
        this.totalFiles = totalFiles;
        this.completeFiles = completeFiles;
        this.filesInTransfer = new ArrayList<FileInTransfer>();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getTotalFiles() {
        return this.totalFiles;
    }

    public int getCompleteFiles() {
        return this.completeFiles;
    }

    public List<FileInTransfer> getFilesInTransfer() {
        return this.filesInTransfer;
    }

    public void addFileInTransfer(String name, long totalSize, long bytesRead) {
        this.filesInTransfer.add(new FileInTransfer(name, totalSize, bytesRead));
    }

    public class FileInTransfer {
        private String name;
        private long totalSize;
        private long bytesRead;

        public FileInTransfer(String name, long totalSize, long bytesRead) {
            this.name = name;
            this.totalSize = totalSize;
            this.bytesRead = bytesRead;
        }

        public String getName() {
            return this.name;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getBytesRead() {
            return this.bytesRead;
        }
    }
}

