/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.endpoint;

import java.util.Iterator;
import org.duracloud.chunk.util.ChunkUtil;

public class ChunkFilteredIterator
implements Iterator<String> {
    private Iterator<String> iterator;
    private String nextItem;
    private ChunkUtil chunkUtil;

    public ChunkFilteredIterator(Iterator<String> iterator) {
        this.iterator = iterator;
        this.nextItem = null;
        this.chunkUtil = new ChunkUtil();
    }

    @Override
    public boolean hasNext() {
        if (null == this.nextItem && this.iterator.hasNext()) {
            this.nextItem = this.getNextFilteredItem();
        }
        return null != this.nextItem;
    }

    private String getNextFilteredItem() {
        String item = null;
        while (this.iterator.hasNext() && null == item) {
            item = this.iterator.next();
            if (this.chunkUtil.isChunk(item)) {
                item = null;
                continue;
            }
            if (!this.chunkUtil.isChunkManifest(item)) continue;
            item = this.chunkUtil.preChunkedContentId(item);
        }
        return item;
    }

    @Override
    public String next() {
        if (null == this.nextItem) {
            this.nextItem = this.getNextFilteredItem();
        }
        String item = this.nextItem;
        this.nextItem = this.getNextFilteredItem();
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported!");
    }
}

