/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.sync.mgmt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.duracloud.sync.mgmt.ChangedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedList {
    private static final Logger log = LoggerFactory.getLogger(ChangedList.class);
    private LinkedHashMap<String, ChangedFile> fileList = new LinkedHashMap();
    private long listVersion = 0L;
    private static ChangedList instance;

    public static synchronized ChangedList getInstance() {
        if (instance == null) {
            instance = new ChangedList();
        }
        return instance;
    }

    private ChangedList() {
    }

    public void addChangedFile(File changedFile) {
        if (null != changedFile) {
            this.addChangedFile(new ChangedFile(changedFile));
        } else {
            log.warn("The changedFile parameter was unexpectedly null. Ignored.");
        }
    }

    public int getListSize() {
        return this.fileList.size();
    }

    protected synchronized void addChangedFile(ChangedFile changedFile) {
        this.fileList.put(changedFile.getFile().getAbsolutePath(), changedFile);
        this.incrementVersion();
    }

    public synchronized void clear() {
        this.fileList.clear();
    }

    public synchronized ChangedFile getChangedFile() {
        if (this.fileList.isEmpty()) {
            return null;
        }
        String key = this.fileList.keySet().iterator().next();
        ChangedFile changedFile = (ChangedFile)this.fileList.remove(key);
        this.incrementVersion();
        return changedFile;
    }

    private void incrementVersion() {
        this.listVersion = this.listVersion < Long.MAX_VALUE ? ++this.listVersion : 0L;
    }

    public long getVersion() {
        return this.listVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long persist(File persistFile) {
        try {
            long persistVersion;
            HashMap fileListClone;
            FileOutputStream fileStream = new FileOutputStream(persistFile);
            ObjectOutputStream oStream = new ObjectOutputStream(fileStream);
            ChangedList changedList = this;
            synchronized (changedList) {
                fileListClone = (HashMap)this.fileList.clone();
                persistVersion = this.listVersion;
            }
            oStream.writeObject(fileListClone);
            oStream.close();
            return persistVersion;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to persist File Changed List:" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(File persistFile, List<File> contentDirs) {
        try {
            FileInputStream fileStream = new FileInputStream(persistFile);
            ObjectInputStream oStream = new ObjectInputStream(fileStream);
            ChangedList changedList = this;
            synchronized (changedList) {
                this.fileList = (LinkedHashMap)oStream.readObject();
                if (contentDirs != null && !contentDirs.isEmpty()) {
                    Iterator<Map.Entry<String, ChangedFile>> entries = this.fileList.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry<String, ChangedFile> entry = entries.next();
                        ChangedFile file = entry.getValue();
                        boolean watched = false;
                        for (File contentDir : contentDirs) {
                            if (!file.getFile().getAbsolutePath().startsWith(contentDir.getAbsolutePath())) continue;
                            watched = true;
                            break;
                        }
                        if (watched) continue;
                        entries.remove();
                    }
                }
            }
            oStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to restore File Changed List:" + e.getMessage(), e);
        }
    }

    public synchronized List<File> peek(int maxFiles) {
        LinkedList<File> files = new LinkedList<File>();
        Iterator<Map.Entry<String, ChangedFile>> it = this.fileList.entrySet().iterator();
        for (int count = 0; it.hasNext() && count < maxFiles; ++count) {
            files.add(it.next().getValue().getFile());
        }
        return files;
    }
}

