/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload.panel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import org.apache.commons.io.FileUtils;
import org.duracloud.upload.UploadFacilitator;
import org.duracloud.upload.UploadStatus;
import org.duracloud.upload.Uploader;

public class StatusPanel
extends JPanel {
    private JLabel file1NameLabel;
    private JLabel file1StatusLabel;
    private JLabel file1TotalLabel;
    private JLabel file2NameLabel;
    private JLabel file2StatusLabel;
    private JLabel file2TotalLabel;
    private JLabel file3NameLabel;
    private JLabel file3StatusLabel;
    private JLabel file3TotalLabel;
    private JLabel uploadNameLabel;
    private JLabel uploadStatusLabel;
    private JLabel uploadTotalLabel;
    private JProgressBar file1ProgressBar;
    private JProgressBar file2ProgressBar;
    private JProgressBar file3ProgressBar;
    private JProgressBar uploadProgressBar;
    private JSeparator separator;
    private JButton cancelButton;
    private UploadFacilitator facilitator;
    private Uploader uploader;
    private static final String columnSpecs = "3dlu,90dlu:grow,2dlu,right:30dlu,2dlu,100dlu,2dlu,30dlu,3dlu";
    private static final String rowSpecs = "5dlu,15dlu,3dlu,15dlu,3dlu,15dlu,10dlu,15dlu,10dlu:grow,pref,3dlu";

    public StatusPanel(UploadFacilitator facilitator) {
        super(new FormLayout(columnSpecs, rowSpecs));
        this.initComponents(new ChangeListener());
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.file1NameLabel, cc.xyw(2, 2, 1));
        this.add((Component)this.file1StatusLabel, cc.xyw(4, 2, 1));
        this.add((Component)this.file1TotalLabel, cc.xyw(8, 2, 1));
        this.add((Component)this.file2NameLabel, cc.xyw(2, 4, 1));
        this.add((Component)this.file2StatusLabel, cc.xyw(4, 4, 1));
        this.add((Component)this.file2TotalLabel, cc.xyw(8, 4, 1));
        this.add((Component)this.file3NameLabel, cc.xyw(2, 6, 1));
        this.add((Component)this.file3StatusLabel, cc.xyw(4, 6, 1));
        this.add((Component)this.file3TotalLabel, cc.xyw(8, 6, 1));
        this.add((Component)this.uploadNameLabel, cc.xyw(2, 8, 1));
        this.add((Component)this.uploadStatusLabel, cc.xyw(4, 8, 1));
        this.add((Component)this.uploadTotalLabel, cc.xyw(8, 8, 1));
        this.add((Component)this.file1ProgressBar, cc.xyw(6, 2, 1));
        this.add((Component)this.file2ProgressBar, cc.xyw(6, 4, 1));
        this.add((Component)this.file3ProgressBar, cc.xyw(6, 6, 1));
        this.add((Component)this.uploadProgressBar, cc.xyw(6, 8, 1));
        this.add((Component)this.separator, cc.xyw(2, 7, 7));
        this.add((Component)this.cancelButton, cc.xyw(6, 10, 3));
        this.facilitator = facilitator;
    }

    private void initComponents(ActionListener actionListener) {
        this.file1NameLabel = new JLabel("");
        this.file1StatusLabel = new JLabel("");
        this.file1TotalLabel = new JLabel("");
        this.file2NameLabel = new JLabel("");
        this.file2StatusLabel = new JLabel("");
        this.file2TotalLabel = new JLabel("");
        this.file3NameLabel = new JLabel("");
        this.file3StatusLabel = new JLabel("");
        this.file3TotalLabel = new JLabel("");
        this.uploadNameLabel = new JLabel("Files Uploaded");
        this.uploadStatusLabel = new JLabel("");
        this.uploadTotalLabel = new JLabel("");
        this.file1ProgressBar = new JProgressBar(0, 1);
        this.file1ProgressBar.setVisible(false);
        this.file2ProgressBar = new JProgressBar(0, 1);
        this.file2ProgressBar.setVisible(false);
        this.file3ProgressBar = new JProgressBar(0, 1);
        this.file3ProgressBar.setVisible(false);
        this.uploadProgressBar = new JProgressBar(0, 1);
        this.separator = new JSeparator();
        this.cancelButton = new JButton("Cancel Upload");
        URL cancelIcon = this.getClass().getClassLoader().getResource("cancel.png");
        this.cancelButton.setIcon(new ImageIcon(cancelIcon));
        this.cancelButton.addActionListener(actionListener);
    }

    private void updateStatusView(UploadStatus status) {
        UploadStatus.FileInTransfer fit;
        int complete = status.getCompleteFiles();
        int total = status.getTotalFiles();
        this.uploadStatusLabel.setText(String.valueOf(complete));
        this.uploadTotalLabel.setText(String.valueOf(total));
        this.uploadProgressBar.setMaximum(total);
        this.uploadProgressBar.setValue(complete);
        this.uploadProgressBar.setStringPainted(true);
        List<UploadStatus.FileInTransfer> files = status.getFilesInTransfer();
        int numFiles = files.size();
        if (numFiles > 0) {
            fit = files.get(0);
            this.file1NameLabel.setText(fit.getName());
            this.file1StatusLabel.setText(FileUtils.byteCountToDisplaySize(fit.getBytesRead()));
            this.file1TotalLabel.setText(FileUtils.byteCountToDisplaySize(fit.getTotalSize()));
            this.file1ProgressBar.setMaximum(new Long(fit.getTotalSize()).intValue());
            this.file1ProgressBar.setValue(new Long(fit.getBytesRead()).intValue());
            this.file1ProgressBar.setVisible(true);
            this.file1ProgressBar.setStringPainted(true);
        } else {
            this.file1NameLabel.setText("");
            this.file1StatusLabel.setText("");
            this.file1TotalLabel.setText("");
            this.file1ProgressBar.setMaximum(1);
            this.file1ProgressBar.setValue(0);
            this.file1ProgressBar.setVisible(false);
            this.file1ProgressBar.setStringPainted(true);
        }
        if (numFiles > 1) {
            fit = files.get(1);
            this.file2NameLabel.setText(fit.getName());
            this.file2StatusLabel.setText(FileUtils.byteCountToDisplaySize(fit.getBytesRead()));
            this.file2TotalLabel.setText(FileUtils.byteCountToDisplaySize(fit.getTotalSize()));
            this.file2ProgressBar.setMaximum(new Long(fit.getTotalSize()).intValue());
            this.file2ProgressBar.setValue(new Long(fit.getBytesRead()).intValue());
            this.file2ProgressBar.setVisible(true);
            this.file2ProgressBar.setStringPainted(true);
        } else {
            this.file2NameLabel.setText("");
            this.file2StatusLabel.setText("");
            this.file2TotalLabel.setText("");
            this.file2ProgressBar.setMaximum(1);
            this.file2ProgressBar.setValue(0);
            this.file2ProgressBar.setVisible(false);
            this.file2ProgressBar.setStringPainted(true);
        }
        if (numFiles > 2) {
            fit = files.get(2);
            this.file3NameLabel.setText(fit.getName());
            this.file3StatusLabel.setText(FileUtils.byteCountToDisplaySize(fit.getBytesRead()));
            this.file3TotalLabel.setText(FileUtils.byteCountToDisplaySize(fit.getTotalSize()));
            this.file3ProgressBar.setMaximum(new Long(fit.getTotalSize()).intValue());
            this.file3ProgressBar.setValue(new Long(fit.getBytesRead()).intValue());
            this.file3ProgressBar.setVisible(true);
            this.file3ProgressBar.setStringPainted(true);
        } else {
            this.file3NameLabel.setText("");
            this.file3StatusLabel.setText("");
            this.file3TotalLabel.setText("");
            this.file3ProgressBar.setMaximum(1);
            this.file3ProgressBar.setValue(0);
            this.file3ProgressBar.setVisible(false);
            this.file3ProgressBar.setStringPainted(true);
        }
    }

    public void monitorStatus(Uploader uploader) {
        this.uploader = uploader;
        Thread monitorThread = new Thread(new StatusMonitor());
        monitorThread.start();
    }

    private void completeUpload() {
        this.facilitator.completeUpload();
    }

    private class StatusMonitor
    implements Runnable {
        private StatusMonitor() {
        }

        @Override
        public void run() {
            UploadStatus status;
            do {
                this.wait(1000);
                status = StatusPanel.this.uploader.getUploadStatus();
                StatusPanel.this.updateStatusView(status);
            } while (!status.isComplete());
            StatusPanel.this.completeUpload();
        }

        private void wait(int milliseconds) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ChangeListener
    implements ActionListener {
        private ChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == StatusPanel.this.cancelButton) {
                if (null != StatusPanel.this.uploader) {
                    StatusPanel.this.uploader.stopUpload();
                }
                StatusPanel.this.completeUpload();
            }
        }
    }
}

