/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribePoliciesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String autoScalingGroupName;
    private ListWithAutoConstructFlag<String> policyNames;
    private ListWithAutoConstructFlag<String> policyTypes;
    private String nextToken;
    private Integer maxRecords;

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public DescribePoliciesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public List<String> getPolicyNames() {
        if (this.policyNames == null) {
            this.policyNames = new ListWithAutoConstructFlag();
            this.policyNames.setAutoConstruct(true);
        }
        return this.policyNames;
    }

    public void setPolicyNames(Collection<String> policyNames) {
        if (policyNames == null) {
            this.policyNames = null;
            return;
        }
        ListWithAutoConstructFlag policyNamesCopy = new ListWithAutoConstructFlag(policyNames.size());
        policyNamesCopy.addAll(policyNames);
        this.policyNames = policyNamesCopy;
    }

    public DescribePoliciesRequest withPolicyNames(String ... policyNames) {
        if (this.getPolicyNames() == null) {
            this.setPolicyNames(new ArrayList<String>(policyNames.length));
        }
        for (String value : policyNames) {
            this.getPolicyNames().add(value);
        }
        return this;
    }

    public DescribePoliciesRequest withPolicyNames(Collection<String> policyNames) {
        if (policyNames == null) {
            this.policyNames = null;
        } else {
            ListWithAutoConstructFlag policyNamesCopy = new ListWithAutoConstructFlag(policyNames.size());
            policyNamesCopy.addAll(policyNames);
            this.policyNames = policyNamesCopy;
        }
        return this;
    }

    public List<String> getPolicyTypes() {
        if (this.policyTypes == null) {
            this.policyTypes = new ListWithAutoConstructFlag();
            this.policyTypes.setAutoConstruct(true);
        }
        return this.policyTypes;
    }

    public void setPolicyTypes(Collection<String> policyTypes) {
        if (policyTypes == null) {
            this.policyTypes = null;
            return;
        }
        ListWithAutoConstructFlag policyTypesCopy = new ListWithAutoConstructFlag(policyTypes.size());
        policyTypesCopy.addAll(policyTypes);
        this.policyTypes = policyTypesCopy;
    }

    public DescribePoliciesRequest withPolicyTypes(String ... policyTypes) {
        if (this.getPolicyTypes() == null) {
            this.setPolicyTypes(new ArrayList<String>(policyTypes.length));
        }
        for (String value : policyTypes) {
            this.getPolicyTypes().add(value);
        }
        return this;
    }

    public DescribePoliciesRequest withPolicyTypes(Collection<String> policyTypes) {
        if (policyTypes == null) {
            this.policyTypes = null;
        } else {
            ListWithAutoConstructFlag policyTypesCopy = new ListWithAutoConstructFlag(policyTypes.size());
            policyTypesCopy.addAll(policyTypes);
            this.policyTypes = policyTypesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribePoliciesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public DescribePoliciesRequest withMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ",");
        }
        if (this.getPolicyNames() != null) {
            sb.append("PolicyNames: " + this.getPolicyNames() + ",");
        }
        if (this.getPolicyTypes() != null) {
            sb.append("PolicyTypes: " + this.getPolicyTypes() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: " + this.getMaxRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyNames() == null ? 0 : this.getPolicyNames().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyTypes() == null ? 0 : this.getPolicyTypes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoliciesRequest)) {
            return false;
        }
        DescribePoliciesRequest other = (DescribePoliciesRequest)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getPolicyNames() == null ^ this.getPolicyNames() == null) {
            return false;
        }
        if (other.getPolicyNames() != null && !other.getPolicyNames().equals(this.getPolicyNames())) {
            return false;
        }
        if (other.getPolicyTypes() == null ^ this.getPolicyTypes() == null) {
            return false;
        }
        if (other.getPolicyTypes() != null && !other.getPolicyTypes().equals(this.getPolicyTypes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        return other.getMaxRecords() == null || other.getMaxRecords().equals(this.getMaxRecords());
    }

    @Override
    public DescribePoliciesRequest clone() {
        return (DescribePoliciesRequest)super.clone();
    }
}

