/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codepipeline.model.Artifact;
import com.amazonaws.services.codepipeline.model.transform.ArtifactLocationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class ArtifactJsonMarshaller {
    private static ArtifactJsonMarshaller instance;

    public void marshall(Artifact artifact, JSONWriter jsonWriter) {
        if (artifact == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (artifact.getName() != null) {
                jsonWriter.key("name").value(artifact.getName());
            }
            if (artifact.getRevision() != null) {
                jsonWriter.key("revision").value(artifact.getRevision());
            }
            if (artifact.getLocation() != null) {
                jsonWriter.key("location");
                ArtifactLocationJsonMarshaller.getInstance().marshall(artifact.getLocation(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ArtifactJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ArtifactJsonMarshaller();
        }
        return instance;
    }
}

