/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.chunk;

import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FileChunkerOptions {
    private IOFileFilter fileFilter = TrueFileFilter.TRUE;
    private IOFileFilter dirFilter = TrueFileFilter.TRUE;
    private long maxChunkSize = 0x40000000L;
    private boolean preserveChunkMD5s = true;
    private boolean ignoreLargeFiles = false;

    public FileChunkerOptions() {
    }

    public FileChunkerOptions(long maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public FileChunkerOptions(IOFileFilter dirFilter, long maxChunkSize) {
        this.dirFilter = dirFilter;
        this.maxChunkSize = maxChunkSize;
    }

    public FileChunkerOptions(long maxChunkSize, boolean ignoreLargeFiles) {
        this.maxChunkSize = maxChunkSize;
        this.ignoreLargeFiles = ignoreLargeFiles;
    }

    public FileChunkerOptions(IOFileFilter fileFilter, IOFileFilter dirFilter, long maxChunkSize) {
        this.fileFilter = fileFilter;
        this.dirFilter = dirFilter;
        this.maxChunkSize = maxChunkSize;
    }

    public FileChunkerOptions(IOFileFilter fileFilter, IOFileFilter dirFilter, long maxChunkSize, boolean preserveChunkMD5s, boolean ignoreLargeFiles) {
        this.fileFilter = fileFilter;
        this.dirFilter = dirFilter;
        this.maxChunkSize = maxChunkSize;
        this.preserveChunkMD5s = preserveChunkMD5s;
        this.ignoreLargeFiles = ignoreLargeFiles;
    }

    public IOFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public IOFileFilter getDirFilter() {
        return this.dirFilter;
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public boolean isPreserveChunkMD5s() {
        return this.preserveChunkMD5s;
    }

    public boolean isIgnoreLargeFiles() {
        return this.ignoreLargeFiles;
    }
}

