/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload;

import java.awt.CardLayout;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.duracloud.upload.UploadFacilitator;
import org.duracloud.upload.Uploader;
import org.duracloud.upload.panel.CompletedPanel;
import org.duracloud.upload.panel.ConnectionPanel;
import org.duracloud.upload.panel.SelectionPanel;
import org.duracloud.upload.panel.StartupPanel;
import org.duracloud.upload.panel.StatusPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTool
extends JPanel
implements UploadFacilitator {
    private static final Logger log = LoggerFactory.getLogger(UploadTool.class);
    private static final String CONNECTION_PANEL = "connectionPanel";
    private static final String SELECTION_PANEL = "selectionPanel";
    private static final String STARTUP_PANEL = "startupPanel";
    private static final String STATUS_PANEL = "statusPanel";
    private static final String COMPLETED_PANEL = "completedPanel";
    private Uploader uploader;
    private StartupPanel startupPanel;
    private StatusPanel statusPanel;
    private CompletedPanel completedPanel;

    public UploadTool() {
        super(new CardLayout());
        this.addToolComponents();
        log.debug("constructing");
    }

    private void addToolComponents() {
        this.add((Component)new ConnectionPanel(this), CONNECTION_PANEL);
        this.add((Component)new SelectionPanel(this), SELECTION_PANEL);
        this.startupPanel = new StartupPanel(this);
        this.add((Component)this.startupPanel, STARTUP_PANEL);
        this.statusPanel = new StatusPanel(this);
        this.add((Component)this.statusPanel, STATUS_PANEL);
        this.completedPanel = new CompletedPanel(this);
        this.add((Component)this.completedPanel, COMPLETED_PANEL);
    }

    public UploadTool(String host, int port, String username, String password, String spaceId, String storeId) {
        this();
        this.connect(host, port, username, password, spaceId, storeId);
    }

    private void setViewPanel(String panelId) {
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, panelId);
    }

    @Override
    public void connect(String host, int port, String username, String password, String spaceId, String storeId) {
        log.info("Upload Tool connecting to: {}:{}/{}:{}", host, port, spaceId, storeId);
        try {
            this.uploader = new Uploader(host, port, username, password, spaceId, storeId);
            this.setViewPanel(SELECTION_PANEL);
        }
        catch (Exception e) {
            String msg = "Could not connect to DuraCloud based on the provided host, username, and password. Please check these values and try again.";
            this.showErrorMessage(msg);
        }
    }

    @Override
    public void startUpload(List<File> items) {
        try {
            this.setViewPanel(STARTUP_PANEL);
            this.uploader.startUpload(items);
            this.startupPanel.monitorStatus(this.uploader);
        }
        catch (Exception e) {
            String msg = "Error encountered on upload: " + e.getMessage();
            log.error(msg);
            this.showErrorMessage(msg);
        }
    }

    private void showErrorMessage(String msg) {
        int type = 0;
        JOptionPane.showMessageDialog(this, msg, "Error", type);
    }

    @Override
    public void showStatus() {
        this.statusPanel.monitorStatus(this.uploader);
        this.setViewPanel(STATUS_PANEL);
    }

    @Override
    public void completeUpload() {
        log.info("Upload Completed");
        this.completedPanel.displayResults(this.uploader);
        this.setViewPanel(COMPLETED_PANEL);
    }

    @Override
    public void exit() {
        System.exit(0);
    }
}

