/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload.panel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.duracloud.sync.mgmt.SyncSummary;
import org.duracloud.upload.UploadFacilitator;
import org.duracloud.upload.Uploader;

public class CompletedPanel
extends JPanel {
    private JLabel completeLabel;
    private JLabel successLabel;
    private JLabel failedLabel;
    private JButton failedButton;
    private JButton exitButton;
    private UploadFacilitator facilitator;
    private String failedItems;
    private static final String columnSpecs = "115dlu,10dlu,40dlu,60dlu,40dlu,10dlu,115dlu";
    private static final String rowSpecs = "15dlu,pref,5dlu,pref,5dlu,pref,10dlu,pref";

    public CompletedPanel(UploadFacilitator facilitator) {
        super(new FormLayout(columnSpecs, rowSpecs));
        this.initComponents(new ChangeListener());
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.completeLabel, cc.xyw(3, 2, 3));
        this.add((Component)this.successLabel, cc.xyw(3, 4, 3));
        this.add((Component)this.failedLabel, cc.xyw(3, 6, 2));
        this.add((Component)this.failedButton, cc.xyw(5, 6, 1));
        this.add((Component)this.exitButton, cc.xyw(4, 8, 1));
        this.facilitator = facilitator;
        this.failedItems = "";
    }

    private void initComponents(ActionListener actionListener) {
        this.completeLabel = new JLabel("Upload is Complete");
        Font defaultFont = this.completeLabel.getFont();
        Font updatedFont = new Font(defaultFont.getFontName(), defaultFont.getStyle(), defaultFont.getSize() + 11);
        this.completeLabel.setFont(updatedFont);
        this.completeLabel.setHorizontalAlignment(0);
        this.successLabel = new JLabel();
        this.successLabel.setHorizontalAlignment(0);
        this.failedLabel = new JLabel();
        this.failedLabel.setHorizontalAlignment(0);
        this.failedButton = new JButton("View");
        this.failedButton.addActionListener(actionListener);
        this.failedButton.setVisible(false);
        this.exitButton = new JButton("Close");
        URL exitIcon = this.getClass().getClassLoader().getResource("close.png");
        this.exitButton.setIcon(new ImageIcon(exitIcon));
        this.exitButton.addActionListener(actionListener);
    }

    public void displayResults(Uploader uploader) {
        long successful = uploader.getSuccessfulTransfers();
        this.successLabel.setText(successful + " files uploaded successfully");
        List<SyncSummary> failed = uploader.getFailedTransfers();
        if (null != failed && failed.size() > 0) {
            this.failedLabel.setText(failed.size() + " files failed to upload");
            for (SyncSummary summary : failed) {
                this.failedItems = this.failedItems + summary.getAbsolutePath() + "\n";
            }
            this.failedButton.setVisible(true);
        }
    }

    private void displayMessage(Object msg, String title) {
        int type = 2;
        JOptionPane.showMessageDialog(this, msg, title, type);
    }

    private class ChangeListener
    implements ActionListener {
        private ChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == CompletedPanel.this.exitButton) {
                CompletedPanel.this.facilitator.exit();
            } else if (e.getSource() == CompletedPanel.this.failedButton) {
                JTextArea textArea = new JTextArea(CompletedPanel.this.failedItems);
                textArea.setLineWrap(false);
                textArea.setMargin(new Insets(5, 5, 5, 5));
                textArea.setEditable(false);
                JScrollPane scrollPane = new JScrollPane();
                scrollPane.setPreferredSize(new Dimension(500, 200));
                scrollPane.getViewport().setView(textArea);
                CompletedPanel.this.displayMessage(scrollPane, "Files which failed to upload");
            }
        }
    }
}

