/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload;

import java.io.File;
import java.util.List;
import org.duracloud.client.ContentStore;
import org.duracloud.client.util.StoreClientUtil;
import org.duracloud.sync.endpoint.DuraStoreChunkSyncEndpoint;
import org.duracloud.sync.endpoint.MonitoredFile;
import org.duracloud.sync.endpoint.SyncEndpoint;
import org.duracloud.sync.mgmt.ChangedList;
import org.duracloud.sync.mgmt.StatusManager;
import org.duracloud.sync.mgmt.SyncManager;
import org.duracloud.sync.mgmt.SyncSummary;
import org.duracloud.sync.walker.DirWalker;
import org.duracloud.upload.UploadStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uploader {
    private static final Logger log = LoggerFactory.getLogger(Uploader.class);
    private SyncManager syncManager;
    private StatusManager statusManager;
    private DirWalker dirWalker;
    private ContentStore contentStore;
    private String host;
    private int port;
    private String username;
    private String password;
    private String spaceId;
    private String storeId;

    public Uploader(String host, int port, String username, String password, String spaceId, String storeId) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.spaceId = spaceId;
        this.storeId = storeId;
        StoreClientUtil clientUtil = new StoreClientUtil();
        this.contentStore = clientUtil.createContentStore(host, port, null, username, password, storeId);
    }

    public void startUpload(List<File> contentItems) {
        log.info("Starting Upload with " + contentItems.size() + " items.");
        DuraStoreChunkSyncEndpoint syncEndpoint = new DuraStoreChunkSyncEndpoint(this.contentStore, this.username, this.spaceId, false, false, 0x40000000L);
        this.syncManager = new SyncManager(contentItems, (SyncEndpoint)syncEndpoint, 3, 10000L);
        this.syncManager.beginSync();
        this.dirWalker = DirWalker.start(contentItems, null);
        this.statusManager = StatusManager.getInstance();
    }

    public UploadStatus getUploadStatus() {
        int completed = Long.valueOf(this.statusManager.getSucceeded()).intValue() + this.statusManager.getFailed().size();
        boolean complete = this.statusManager.getQueueSize() == 0 && this.statusManager.getInWork() == 0L;
        UploadStatus status = new UploadStatus(complete, this.dirWalker.getFilesCount(), completed);
        for (MonitoredFile file : this.syncManager.getFilesInTransfer()) {
            status.addFileInTransfer(file.getName(), file.length(), file.getStreamBytesRead());
        }
        return status;
    }

    public long getSuccessfulTransfers() {
        return this.statusManager.getSucceeded();
    }

    public List<SyncSummary> getFailedTransfers() {
        return this.statusManager.getFailed();
    }

    public void stopUpload() {
        this.dirWalker.stopWalk();
        this.syncManager.terminateSync();
        ChangedList.getInstance().shutdown();
        log.info("Upload Stopped");
    }
}

