/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload.panel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.duracloud.upload.UploadFacilitator;
import org.duracloud.upload.UploadStatus;
import org.duracloud.upload.Uploader;

public class StartupPanel
extends JPanel {
    private JLabel startingLabel;
    private JProgressBar spinnerBar;
    private UploadFacilitator facilitator;
    private Uploader uploader;
    private static final String columnSpecs = "135dlu,20dlu,80dlu,20dlu,135dlu";
    private static final String rowSpecs = "30dlu,pref,10dlu,pref";

    public StartupPanel(UploadFacilitator facilitator) {
        super((LayoutManager)new FormLayout(columnSpecs, rowSpecs));
        this.initComponents();
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.startingLabel, cc.xyw(2, 2, 3));
        this.add((Component)this.spinnerBar, cc.xyw(3, 4, 1));
        this.facilitator = facilitator;
    }

    private void initComponents() {
        this.startingLabel = new JLabel("Upload is Starting");
        Font defaultFont = this.startingLabel.getFont();
        Font updatedFont = new Font(defaultFont.getFontName(), defaultFont.getStyle(), defaultFont.getSize() + 11);
        this.startingLabel.setFont(updatedFont);
        this.startingLabel.setHorizontalAlignment(0);
        this.spinnerBar = new JProgressBar();
        this.spinnerBar.setIndeterminate(true);
    }

    public void monitorStatus(Uploader uploader) {
        this.uploader = uploader;
        Thread monitorThread = new Thread(new StatusMonitor());
        monitorThread.start();
    }

    private void startupComplete() {
        this.facilitator.showStatus();
    }

    private class StatusMonitor
    implements Runnable {
        private StatusMonitor() {
        }

        @Override
        public void run() {
            UploadStatus status;
            do {
                this.wait(1000);
            } while (!(status = StartupPanel.this.uploader.getUploadStatus()).isComplete() && status.getFilesInTransfer().size() <= 0);
            StartupPanel.this.startupComplete();
        }

        private void wait(int milliseconds) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

