/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload.panel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FileUtils;
import org.duracloud.upload.UploadFacilitator;

public class SelectionPanel
extends JPanel {
    private JTable itemTable;
    private DefaultTableModel itemTableModel;
    private JButton addItemButton;
    private JButton removeItemButton;
    private JButton uploadButton;
    private JFileChooser fileChooser;
    private UploadFacilitator facilitator;
    private static final String columnSpecs = "3dlu,pref,3dlu,pref,3dlu:grow,pref,3dlu";
    private static final String rowSpecs = "3dlu,90dlu:grow,3dlu,pref,3dlu";

    public SelectionPanel(UploadFacilitator facilitator) {
        super(new FormLayout(columnSpecs, rowSpecs));
        this.initComponents(new ChangeListener());
        JScrollPane tablePane = new JScrollPane(this.itemTable);
        CellConstraints cc = new CellConstraints();
        this.add((Component)tablePane, cc.xyw(2, 2, 5));
        this.add((Component)this.addItemButton, cc.xy(2, 4));
        this.add((Component)this.removeItemButton, cc.xy(4, 4));
        this.add((Component)this.uploadButton, cc.xy(6, 4));
        this.facilitator = facilitator;
    }

    private void initComponents(ActionListener actionListener) {
        Object[] itemColumnNames = new String[]{"Name", "Size", "Location"};
        this.itemTableModel = new DefaultTableModel(itemColumnNames, 0);
        this.itemTable = new JTable(this.itemTableModel);
        this.addItemButton = new JButton("Add Files and Folders");
        URL addIcon = this.getClass().getClassLoader().getResource("add.png");
        this.addItemButton.setIcon(new ImageIcon(addIcon));
        this.addItemButton.addActionListener(actionListener);
        this.removeItemButton = new JButton("Remove Selected");
        URL removeIcon = this.getClass().getClassLoader().getResource("minus.png");
        this.removeItemButton.setIcon(new ImageIcon(removeIcon));
        this.removeItemButton.addActionListener(actionListener);
        this.uploadButton = new JButton("Start Upload");
        URL startUploadIcon = this.getClass().getClassLoader().getResource("arrow_up.png");
        this.uploadButton.setIcon(new ImageIcon(startUploadIcon));
        this.uploadButton.addActionListener(actionListener);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setMultiSelectionEnabled(true);
    }

    private void addItemsToList(File[] items) {
        for (File item : items) {
            String name = item.getName();
            String size = FileUtils.byteCountToDisplaySize(item.length());
            String location = item.getAbsolutePath();
            if (item.isDirectory()) {
                name = name + " (folder)";
                size = "calculating...";
            }
            if (this.isDuplicate(location)) continue;
            int rowToUpdate = this.itemTableModel.getRowCount();
            this.itemTableModel.addRow(new String[]{name, size, location});
            if (!item.isDirectory()) continue;
            new SizeWorker(item, rowToUpdate).execute();
        }
    }

    public boolean isDuplicate(String addedPath) {
        int rowCount = this.itemTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String itemPath = String.valueOf(this.itemTableModel.getValueAt(i, 2));
            if (!itemPath.equals(addedPath)) continue;
            return true;
        }
        return false;
    }

    private class SizeWorker
    extends SwingWorker<String, String> {
        private File directory;
        private int rowToUpdate;

        public SizeWorker(File directory, int rowToUpdate) {
            this.directory = directory;
            this.rowToUpdate = rowToUpdate;
        }

        @Override
        protected String doInBackground() throws Exception {
            return FileUtils.byteCountToDisplaySize(FileUtils.sizeOfDirectory(this.directory));
        }

        @Override
        protected void done() {
            String size;
            try {
                size = (String)this.get();
            }
            catch (Exception e) {
                size = "";
            }
            SelectionPanel.this.itemTableModel.setValueAt(size, this.rowToUpdate, 1);
        }
    }

    private class ChangeListener
    implements ActionListener {
        private ChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SelectionPanel.this.addItemButton) {
                int returnVal = SelectionPanel.this.fileChooser.showOpenDialog(SelectionPanel.this.itemTable);
                if (returnVal == 0) {
                    SelectionPanel.this.addItemsToList(SelectionPanel.this.fileChooser.getSelectedFiles());
                }
            } else if (e.getSource() == SelectionPanel.this.removeItemButton) {
                int[] selectedRows = SelectionPanel.this.itemTable.getSelectedRows();
                Arrays.sort(selectedRows);
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    SelectionPanel.this.itemTableModel.removeRow(selectedRows[i]);
                }
            } else if (e.getSource() == SelectionPanel.this.uploadButton) {
                ArrayList<File> items = new ArrayList<File>();
                int rowCount = SelectionPanel.this.itemTableModel.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    String path = String.valueOf(SelectionPanel.this.itemTableModel.getValueAt(i, 2));
                    File item = new File(path);
                    if (!item.exists()) continue;
                    items.add(item);
                }
                SelectionPanel.this.facilitator.startUpload(items);
            }
        }
    }
}

