/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.upload.panel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.duracloud.upload.UploadFacilitator;

public class ConnectionPanel
extends JPanel {
    private static final String HOST_PREFIX = "https://";
    private static final String HOST_SUFFIX = ".duracloud.org";
    private JLabel hostLabel;
    private JLabel hostPrefixLabel;
    private JLabel hostSuffixLabel;
    private JLabel usernameLabel;
    private JLabel passwordLabel;
    private JLabel spaceIdLabel;
    private JTextField hostField;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JTextField spaceIdField;
    private JButton continueButton;
    private UploadFacilitator facilitator;
    private static final String columnSpecs = "60dlu,right:max(30dlu;pref),6dlu,pref,2dlu,25dlu:grow,2dlu,70dlu,60dlu";
    private static final String rowSpecs = "10dlu,pref,5dlu,pref,5dlu,pref,5dlu,pref,8dlu:grow,pref,5dlu";

    public ConnectionPanel(UploadFacilitator facilitator) {
        super((LayoutManager)new FormLayout(columnSpecs, rowSpecs));
        this.initComponents(new ChangeListener());
        CellConstraints cc = new CellConstraints();
        this.add((Component)this.hostLabel, cc.xyw(2, 2, 1));
        this.add((Component)this.usernameLabel, cc.xyw(2, 4, 1));
        this.add((Component)this.passwordLabel, cc.xyw(2, 6, 1));
        this.add((Component)this.spaceIdLabel, cc.xyw(2, 8, 1));
        this.add((Component)this.hostField, cc.xyw(6, 2, 1));
        this.add((Component)this.usernameField, cc.xyw(4, 4, 5));
        this.add((Component)this.passwordField, cc.xyw(4, 6, 5));
        this.add((Component)this.spaceIdField, cc.xyw(4, 8, 5));
        this.add((Component)this.continueButton, cc.xyw(8, 10, 1));
        this.add((Component)this.hostPrefixLabel, cc.xyw(4, 2, 1));
        this.add((Component)this.hostSuffixLabel, cc.xyw(8, 2, 1));
        this.facilitator = facilitator;
    }

    private void initComponents(ActionListener actionListener) {
        this.hostLabel = new JLabel("Host:");
        this.hostPrefixLabel = new JLabel(HOST_PREFIX);
        this.hostSuffixLabel = new JLabel(HOST_SUFFIX);
        this.passwordLabel = new JLabel("Password:");
        this.usernameLabel = new JLabel("Username:");
        this.spaceIdLabel = new JLabel("Space ID:");
        this.hostField = new JTextField();
        this.usernameField = new JTextField();
        this.passwordField = new JPasswordField();
        this.spaceIdField = new JTextField();
        this.continueButton = new JButton("Continue");
        URL continueIcon = this.getClass().getClassLoader().getResource("arrow_right.png");
        this.continueButton.setIcon(new ImageIcon(continueIcon));
        this.continueButton.setHorizontalTextPosition(2);
        this.continueButton.setIconTextGap(8);
        this.continueButton.addActionListener(actionListener);
    }

    private void displayMessage(String msg) {
        int type = 2;
        JOptionPane.showMessageDialog(this, msg, "Notice", type);
    }

    private class ChangeListener
    implements ActionListener {
        private ChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ConnectionPanel.this.continueButton) {
                String host = ConnectionPanel.this.hostField.getText();
                String username = ConnectionPanel.this.usernameField.getText();
                String password = new String(ConnectionPanel.this.passwordField.getPassword());
                String spaceId = ConnectionPanel.this.spaceIdField.getText();
                if (host.isEmpty() || username.isEmpty() || password.isEmpty() || spaceId.isEmpty()) {
                    ConnectionPanel.this.displayMessage("All fields are required.");
                } else {
                    String fullHost = host + ConnectionPanel.HOST_SUFFIX;
                    ConnectionPanel.this.facilitator.connect(fullHost, 443, username, password, spaceId, null);
                }
            }
        }
    }
}

