/*
 * Decompiled with CFR 0.152.
 */
package org.duraspace.bagit;

import com.esotericsoftware.yamlbeans.YamlReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class BagConfig {
    public static final String BAG_INFO_KEY = "bag-info.txt";
    private static final String APTRUST_INFO_KEY = "aptrust-info.txt";
    public static final String SOURCE_ORGANIZATION_KEY = "Source-Organization";
    public static final String ORGANIZATION_ADDRESS_KEY = "Organization-Address";
    public static final String CONTACT_NAME_KEY = "Contact-Name";
    public static final String CONTACT_PHONE_KEY = "Contact-Phone";
    public static final String CONTACT_EMAIL_KEY = "Contact-Email";
    public static final String EXTERNAL_DESCRIPTION_KEY = "External-Description";
    public static final String EXTERNAL_IDENTIFIER_KEY = "External-Identifier";
    public static final String INTERNAL_SENDER_DESCRIPTION_KEY = "Internal-Sender-Description";
    public static final String INTERNAL_SENDER_IDENTIFIER_KEY = "Internal-Sender-Identifier";
    public static final String BAGGING_DATE_KEY = "Bagging-Date";
    public static final String BAG_SIZE_KEY = "Bag-Size";
    public static final String PAYLOAD_OXUM_KEY = "Payload-Oxum";
    public static final String BAG_GROUP_IDENTIFIER = "Bag-Group-Identifier";
    public static final String TITLE_KEY = "Title";
    public static final String ACCESS_KEY = "Access";
    private Map<String, Map<String, String>> map;

    public BagConfig(File bagConfigFile) {
        String bagConfigFilePath = bagConfigFile.getAbsolutePath();
        YamlReader reader = null;
        try {
            reader = new YamlReader((Reader)new FileReader(bagConfigFile));
            this.map = (Map)reader.read();
            if (this.getBagInfo() == null) {
                throw new RuntimeException("The bag-info.txt key is not present in the " + bagConfigFilePath);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("The specified bag config file does not exist: " + bagConfigFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException("The specified bag config file could not be parsed: " + e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Map<String, String> getBagInfo() {
        return Collections.unmodifiableMap(this.map.get(BAG_INFO_KEY));
    }

    public Map<String, String> getAPTrustInfo() {
        return Collections.unmodifiableMap(this.map.get(APTRUST_INFO_KEY));
    }

    public Set<String> getTagFiles() {
        return this.map.keySet();
    }

    public boolean hasTagFile(String tagFile) {
        return this.map.containsKey(tagFile);
    }

    public Map<String, String> getFieldsForTagFile(String tagFile) {
        return this.map.get(tagFile);
    }

    public static enum AccessTypes {
        RESTRICTED,
        INSTITUTION,
        CONSORTIA;

    }
}

